package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: 商户池 养号维度 枚举
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.09.12 16:01
 */
@Getter
@AllArgsConstructor
public enum MerPoolNurturingDimensionEnum {

    PAY_NUM(1, "支付量"),

    PULL_NUM(2, "拉起量"),

    PAY_AMOUNT(3, "支付金额"),

    ;

    private final Integer code;
    private final String desc;

    public static MerPoolNurturingDimensionEnum getByCode(Integer dimension) {
        for (MerPoolNurturingDimensionEnum value : MerPoolNurturingDimensionEnum.values()) {
            if (value.getCode().equals(dimension)) {
                return value;
            }
        }
        return null;
    }
}
