package cn.tuia.payment.api.enums;

import com.google.common.base.Strings;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: RefundStatusLeshuaEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2025.01.10 15:03
 */
@Getter
@AllArgsConstructor
public enum RefundStatusLeshuaEnum {
    // 10	退款中
    //11	退款成功
    //12	退款失败
    SUCCESS(RefundStatusEnum.REFUND_SUCCESS, "11"),
    FAIL(RefundStatusEnum.REFUND_FAIL, "12"),
    PROCESSING(RefundStatusEnum.REFUND_PROCESS, "10"),
    ;
    private final RefundStatusEnum insideCode;
    private final String outsideCode;

    public static Integer getByOutsideCode(String outsideCode) {
        for (RefundStatusLeshuaEnum value : RefundStatusLeshuaEnum.values()) {
            if (value.getOutsideCode().equals(outsideCode)) {
                return value.getInsideCode().getCode();
            }
        }
        return RefundStatusEnum.MER_PROCESS.getCode();
    }
}
