package cn.tuia.payment.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * 代扣明细状态枚举
 */
@Getter
public enum WithholdDetailStatusEnum {

    PAID(1, "已支付"),
    POINTS_GRANTED(2, "已发积分"),
    REFUNDED(3, "已退款"),
    ;

    private final Integer code;
    private final String desc;

    WithholdDetailStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static WithholdDetailStatusEnum getByCode(Integer code) {
        return Stream.of(WithholdDetailStatusEnum.values())
                .filter(e -> e.getCode().equals(code))
                .findFirst()
                .orElse(null);
    }
}
