package cn.tuia.payment.api.enums.ali;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: AlipayFundTransferStatusEnum
 * @projectName tuia-payment
 * @description: 转账单据状态。
 * SUCCESS（该笔转账交易成功）：成功；
 * FAIL：失败（具体失败原因请参见error_code以及fail_reason返回值）；
 * DEALING：处理中（转账到支付宝账户不涉及）；
 * REFUND：退票（转账到支付宝账户不涉及）；
 * @date 2024.07.04 16:51
 */
@Getter
@AllArgsConstructor
public enum AlipayFundTransferStatusEnum {


    SUCCESS("SUCCESS", "成功"),
    FAIL("FAIL", "失败"),
    DEALING("DEALING", "处理中"),
    REFUND("REFUND", "退票"),
    ;

    private final String code;
    private final String msg;
}
