package cn.tuia.payment.api.utils;

/**
 * @author lizhiheng
 */
public class SubMerchantUtils {

    /**
     * 获取子商户号
     * @param fullString 原始字符串，包含商编+子商户号+后缀
     * @param prefix 商编部分的字符串
     * @param suffix 后缀部分的字符串
     * @return 子商户号
     */
    public static String extractSubMerchantId(String fullString, String prefix, String suffix) {
        int startIndex = prefix.length();
        int endIndex = fullString.length() - suffix.length();

        if (startIndex < endIndex && startIndex >= 0 && endIndex <= fullString.length()) {
            return fullString.substring(startIndex, endIndex);
        } else {
            throw new IllegalArgumentException("无法提取子商户号");
        }
    }

    public static void main(String[] args) {
        String exampleString = "555022088710037246695AB123";
        String prefix = "555022"; // 商编部分
        String suffix = "AB123"; // 后缀部分

        String subMerchantId = extractSubMerchantId(exampleString, prefix, suffix);
        System.out.println("子商户号：" + subMerchantId); // 输出子商户号
    }
}