package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: ComplainStatusEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.06 14:49
 */
@Getter
@AllArgsConstructor
public enum ComplainStatusLiandongWxEnum {


    /**
     * 待处理
     */
    PENDING("待处理", ComplainStatusEnum.WAIT_PROCESS.name()),

    /**
     * 处理中
     */
    PROCESSING("处理中", ComplainStatusEnum.PROCESSING.name()),

    /**
     * 已处理完成
     */
    PROCESSED("已处理完成", ComplainStatusEnum.PROCESSED.name()),
    ;

    private final String description;
    private final String commonComplaintStatus;


    public static String getCommonComplaintStatus(String name) {
        for (ComplainStatusLiandongWxEnum value : ComplainStatusLiandongWxEnum.values()) {
            if (value.name().equals(name)) {
                return value.getCommonComplaintStatus();
            }
        }
        return null;
    }
}
