package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhiheng
 */


@Getter
@AllArgsConstructor
public enum RefundStatusScUnionPayEnum {
    UNKNOWN(RefundStatusEnum.REFUND_UNKNOWN, "UNKNOWN"), // 不明确的交易状态 需要调退 款查询接口确认退款结果
    SUCCESS(RefundStatusEnum.REFUND_SUCCESS, "SUCCESS"), // 退款成功 FAIL 退款失败
    PROCESSING(RefundStatusEnum.REFUND_PROCESS, "PROCESSING"), // 退款处理中 需要调退款查询 接口确认退款结果
    FAIL(RefundStatusEnum.REFUND_FAIL, "FAIL"), //  退款失败
    ;
    private final RefundStatusEnum insideCode;
    private final String sichuanUnionPayCode;


}
