/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.tools.deviceid;

import cn.tuia.tools.deviceid.DeviceDTO;
import cn.tuia.tools.deviceid.DeviceIdUtilService;
import cn.tuia.tools.deviceid.DeviceMd5BlackEnum;
import cn.tuia.tools.deviceid.DeviceTypeEnum;
import cn.tuia.tools.deviceid.LegalMd5Factory;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public class DeviceIdUtils {
    public static void checkAndGenerateDeviceId(DeviceDTO deviceDTO) {
        DeviceIdUtilService.checkAndGenerateDeviceId(deviceDTO);
    }

    public static String getUUIDAndMd5(String desc) {
        return DeviceIdUtilService.getUUIDAndMd5(desc);
    }

    public static boolean checkLegalMd5(String str, DeviceTypeEnum typeEnum) {
        return LegalMd5Factory.checkLegalMd5(str, typeEnum);
    }

    public static boolean isLowerCase32Md5(String str) {
        return LegalMd5Factory.isLowerCase32Md5(str);
    }

    public static Boolean startWithDesc(String desc, String deviceUUID) {
        if (StringUtils.isEmpty((String)desc) || desc.length() > 4) {
            return false;
        }
        if (StringUtils.isBlank((String)deviceUUID)) {
            return false;
        }
        return deviceUUID.startsWith(desc);
    }

    public static void main(String[] args) {
        System.out.println("\u3010\u6d4b\u8bd5\u3011 imei \u5408\u6cd5\uff1a 351710058880864");
        DeviceDTO deviceDTO = DeviceDTO.builder().imei("351710058880864").deviceId("11").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        DeviceIdUtils.printResult(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 idfa \u5408\u6cd5: CCD6E1CD-8C4B-40CB-8A62-4BBC7AFE07D6");
        deviceDTO = DeviceDTO.builder().idfa("CCD6E1CD-8C4B-40CB-8A62-4BBC7AFE07D6").deviceId("22").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        DeviceIdUtils.printResult(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 oaid \u5408\u6cd5: 351710058880864");
        deviceDTO = DeviceDTO.builder().oaid("351710058880864").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        DeviceIdUtils.printResult(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 imei Md5 \u5408\u6cd5: d41d8cd98f00b204e9800998ecf84271");
        deviceDTO = DeviceDTO.builder().imei_md5("d41d8cd98f00b204e9800998ecf84271").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        DeviceIdUtils.printResult(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 idfa Md5 \u5408\u6cd5");
        deviceDTO = DeviceDTO.builder().idfa_md5("d41d8cd98f00b204e9800998ecf84272").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        DeviceIdUtils.printResult(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 oaid Md5 \u5408\u6cd5");
        deviceDTO = DeviceDTO.builder().oaid_md5("d41d8cd98f00b204e9800998ecf84273").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        DeviceIdUtils.printResult(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 deviceId \u5408\u6cd5\uff1a d41d8cd98f00b204e9800998ecf84274");
        deviceDTO = DeviceDTO.builder().deviceId("d41d8cd98f00b204e9800998ecf84274").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        DeviceIdUtils.printResult(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 imei \u4f20\u9519\u4e86\u4f20\u4e86MD5\uff1a d41d8cd98f00b204e9800998ecf84275");
        deviceDTO = DeviceDTO.builder().imei("d41d8cd98f00b204e9800998ecf84275").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        DeviceIdUtils.printResult(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 imeiMd5 \u4e0d\u5408\u6cd5\uff1a cfcd208495d565ef66e7dff9f98764da");
        deviceDTO = DeviceDTO.builder().imei_md5(DeviceMd5BlackEnum.ERROR_1.getDeviceMd5()).deviceType(DeviceTypeEnum.IMEI.getCode()).build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        DeviceIdUtils.printResult(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 deviceId \u4e0d\u5408\u6cd5\uff0coaidMd5 \u5408\u6cd5\uff1a d41d8cd98f00b204e9800998ecf84273");
        deviceDTO = DeviceDTO.builder().deviceId(DeviceMd5BlackEnum.ERROR_1.getDeviceMd5()).oaid_md5("d41d8cd98f00b204e9800998ecf84273").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        DeviceIdUtils.printResult(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 deviceId \u4e0d\u5408\u6cd5\uff0cimei \u4f20\u9519\u6210md5\uff1a d41d8cd98f00b204e9800998ecf84273");
        deviceDTO = DeviceDTO.builder().deviceId(DeviceMd5BlackEnum.ERROR_1.getDeviceMd5()).imei("d41d8cd98f00b204e9800998ecf84273").build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        DeviceIdUtils.printResult(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 \u91c7\u96c6imei\uff0cimei\u4f20\u9519\uff1a cfcd208495d565ef66e7dff9f98764da");
        deviceDTO = DeviceDTO.builder().imei_md5(DeviceMd5BlackEnum.ERROR_1.getDeviceMd5()).deviceType(DeviceTypeEnum.IMEI.getCode()).build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        DeviceIdUtils.printResult(deviceDTO);
        System.out.println("\u3010\u6d4b\u8bd5\u3011 \u91c7\u96c6 IDFA\uff0cIDFA \u4f20\u9519\uff1a cfcd208495d565ef66e7dff9f98764da");
        deviceDTO = DeviceDTO.builder().idfa("cfcd208495d565ef66e7dff9f98764da").deviceType(DeviceTypeEnum.IDFA.getCode()).build();
        DeviceIdUtils.checkAndGenerateDeviceId(deviceDTO);
        DeviceIdUtils.printResult(deviceDTO);
        String uuidAndMd5 = DeviceIdUtils.getUUIDAndMd5(DeviceTypeEnum.THIRD_DEVICE.getDesc());
        System.out.println("tcid\u968f\u673a\u4e32\uff1a" + uuidAndMd5);
    }

    private static void printResult(DeviceDTO deviceDTO) {
        System.out.println(deviceDTO);
        Assert.isTrue((boolean)LegalMd5Factory.isLowerCase32Md5(deviceDTO.getDeviceId()), (String)"deviceId\u662f\u5426\u5408\u6cd5");
    }
}

