package cn.tuia.tools.deviceid;

/**
 * @Description:
 * @author: 阿海
 * @create: 2020-08-10 19:01
 */
public class ConsumerUtils {

    private static final int TABLES = 2048;
    /**
     * 获取cid
     *
     * @param key
     * @param tables
     * @return
     */
    public static String getTableSuffix(String key, Integer tables) {
        int tbInt = Math.abs(key.hashCode()) % tables;
        String tb = tbInt + "";
        if (tbInt < 10) {
            tb = "000" + tbInt;
        } else if (tbInt < 100) {
            tb = "00" + tbInt;
        } else if (tbInt < 1000) {
            tb = "0" + tbInt;
        }

        return tb;
    }

    /**
     * 拼接userId
     * @param deviceId
     * @param appId
     * @return
     */
    private static String getUserID(String deviceId, Long appId) {
        return deviceId + "-" + appId;
    }

    public static void main(String[] args) {
        String deviceId = "8a18b3af-96b8-4085-986e-a3f8c9fb4921";
        Long appId = 76174L;
        String userID = getUserID(deviceId, appId);
        String tableSuffix = getTableSuffix(userID, TABLES);
        System.out.println(tableSuffix);
    }
}
