package cn.tuia.tools.log;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

/**
 * @author: tangzhen@duiba.com.cn
 * @date:2020/9/10
 * @description: 根据环境打印日志
 **/
@Slf4j
@Component
public class PublicConfigLog implements ApplicationRunner {

    private static boolean can_log;

    @Override
    public void run(ApplicationArguments var1) {
        // 是否是线上机器  deploy_type=fortress 系统环境变量为灰度
        can_log = !SpringEnvironmentUtils.isProdEnv() || ObjectUtils.notEqual(System.getenv("deploy_type"), "normal");
    }

    private static boolean reasonable(String format) {
        return StringUtils.isNotBlank(format) && can_log;
    }

    public static void debug(String format, Object... arguments) {
        if (reasonable(format)) {
            log.debug(format, arguments);
        }
    }

    public static void info(String format, Object... arguments) {
        if (reasonable(format)) {
            log.info(format, arguments);
        }
    }

    /**
     * 打印warn日志
     *
     * @param format    需明确，尽量唯一，方便问题排查追溯来源
     * @param arguments
     */
    public static void warn(String format, Object... arguments) {
        if (reasonable(format)) {
            log.warn(format, arguments);
        }
    }

    /**
     * 打印warn日志
     *
     * @param format    需明确，尽量唯一，方便问题排查追溯来源
     * @param arguments
     */
    public static void error(String format, Object... arguments) {
        if (reasonable(format)) {
            log.error(format, arguments);
        }
    }
}
