package cn.yoofans.manager.center.api.dto;

import java.io.Serializable;

/**
 * 落地页标识
 * Created by sty on 1/10/18.
 */
public class LoadPageInfoDto implements Serializable {

    private static final long serialVersionUID = 2990061849930649857L;

    public static final int STATUS_CAN_NOT_USE = 0;

    public static final int STATUS_WAIT_TO_USE = 1;

    public static final int STATUS_ALREADY_USED = 2;
    /**
     * 落地页地址
     */
    public static final String LOAD_PAGE_URL_INTERFACE_SUFFIX="/mobile/loadpage/skin?id=";



    /**
     * id
     */
    private Long id;

    /**
     * 相关的公众号id
     */
    private Long subscriptionId;

    /**
     * 落地页
     */
    private String loadPageUrl;
    /**
     * 阀值
     */
    private Long thresholdNum;
    /**
     * 状态
     */
    private Integer status;
    /**
     * 删除的标示
     */
    private Boolean deleted;
    /**
     * 排序
     */
    private Long sort;


    /**
     * 落地页类型 1外部 2内部
     */
    private Byte loadPageType;

    /**
     * 皮肤id
     */
    private Long skinId;

    /**
     * 内容Id
     */
    private Long putContentId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSubscriptionId() {
        return subscriptionId;
    }

    public void setSubscriptionId(Long subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getLoadPageUrl() {
        return loadPageUrl;
    }

    public void setLoadPageUrl(String loadPageUrl) {
        this.loadPageUrl = loadPageUrl;
    }

    public Long getThresholdNum() {
        return thresholdNum;
    }

    public void setThresholdNum(Long thresholdNum) {
        this.thresholdNum = thresholdNum;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Long getSort() {
        return sort;
    }

    public void setSort(Long sort) {
        this.sort = sort;
    }

    public Byte getLoadPageType() {
        return loadPageType;
    }

    public void setLoadPageType(Byte loadPageType) {
        this.loadPageType = loadPageType;
    }

    public Long getSkinId() {
        return skinId;
    }

    public void setSkinId(Long skinId) {
        this.skinId = skinId;
    }

    public Long getPutContentId() {
        return putContentId;
    }

    public void setPutContentId(Long putContentId) {
        this.putContentId = putContentId;
    }


    public enum LoadPageType{
        OUTSIDE("1","外部"),
        INSIDE("2","内部");
        private String value;
        private String desc;
        LoadPageType(String value,String desc){
            this.value=value;
            this.desc=desc;
        }
        public String getValue(){
            return this.value;
        }
    }
}
