/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteContentDetailService
 * Author:   amu
 * Date:     2018/3/26 下午5:36
 * Description: 测试类小程序内容详情服务
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.manager.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.manager.center.api.dto.ContentDetailDTO;
import cn.yoofans.manager.center.api.param.ContentDetailPageRequestParam;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈测试类小程序内容详情服务〉
 *
 * @author amu
 * @create 2018/3/26
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteContentDetailService {
    /**
     * 随机获取一个内容
     * @param appId
     * @return
     */
    ContentDetailDTO getRandomContentDetailByAppId(String appId);

    /**
     * 随机获取一个内容（需要缓存用户相关）
     * @param appId
     * @param userName  用户姓名
     * @param userId    用户id
     * @return
     */
	ContentDetailDTO getRandomContentDetailByUser(String appId,Long userId,String userName);
	
	/**
	 * 新增
	 * 
	 * @param dto
	 * @return
	 */
	public ContentDetailDTO insert(ContentDetailDTO dto);


	/**
	 * 根据id获取缓存中数据
	 * @return
	 */
	ContentDetailDTO getContentDetailById(Long id);

	/**
	 * 批量新增
	 * 
	 * @param dto
	 * @return
	 */
	public Integer batchInsert(List<ContentDetailDTO> dto);

	/**
	 * 删除详情
	 * 
	 * @param id
	 * @return
	 */
	public Boolean delete(Long id) throws BizException;

	/**
	 * 修改详情
	 *
	 * @param dto
	 * @param updateDTO
	 * @return
	 */
	public Boolean update(ContentDetailDTO dto) throws BizException;

	/**
	 * 依据Id查询详情
	 * 
	 * @param id
	 * @return
	 */
	public ContentDetailDTO findById(Long id) throws BizException;

	/**
	 * 分页查询类型列表
	 * 
	 * @param queryParam
	 * @return
	 */
	public PageImpl<ContentDetailDTO> getPageList(ContentDetailPageRequestParam queryParam) throws BizException;

}
