package cn.yoofans.manager.center.api.dto.message;

import cn.yoofans.manager.center.api.enums.message.MsgTypeEnum;
import cn.yoofans.manager.center.api.enums.message.NoticeTypeEnum;
import cn.yoofans.manager.center.api.enums.message.TriggerConditionEnum;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

public class MessageConfigDTO implements Serializable {
    private static final long serialVersionUID = -3385950371710803829L;

    /**
     * id
     */
    private Long id;

    /**
     * 触发条件  subscribe关注公众号 CLICK点击菜单 text发送消息 timing定时
     * {@link TriggerConditionEnum}
     */
    private String triggerCondition;

    /**
     * 公众号id
     */
    private Long authorizerId;

    /**
     * 渠道id
     */
    private Long channelId;

    /**
     * 推广位id
     */
    private Long adzoneId;

    /**
     * 消息类型 1客服消息
     * {@link MsgTypeEnum}
     */
    private Integer msgType;

    /**
     * 通知类型 1触发用户 2 关注用户 3指定用户
     * {@link NoticeTypeEnum}
     */
    private Integer noticeType;

    /**
     * 定时表达式
     */
    private String timeExpression;

    /**
     * 定时是否循环 0否 1是
     */
    private Integer loopFlag;

    /**
     * 消息内容
     */
    private String msgContent;

    /**
     * 延时时间
     */
    private Integer laterTime;

    /**
     * 用户文件地址
     */
    private String fileUrl;

    /**
     * 是否删除的标识 0未删除1已删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTriggerCondition() {
        return triggerCondition;
    }

    public void setTriggerCondition(String triggerCondition) {
        this.triggerCondition = triggerCondition;
    }

    public Long getAuthorizerId() {
        return authorizerId;
    }

    public void setAuthorizerId(Long authorizerId) {
        this.authorizerId = authorizerId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getAdzoneId() {
        return adzoneId;
    }

    public void setAdzoneId(Long adzoneId) {
        this.adzoneId = adzoneId;
    }

    public Integer getMsgType() {
        return msgType;
    }

    public void setMsgType(Integer msgType) {
        this.msgType = msgType;
    }

    public Integer getNoticeType() {
        return noticeType;
    }

    public void setNoticeType(Integer noticeType) {
        this.noticeType = noticeType;
    }

    public String getTimeExpression() {
        return timeExpression;
    }

    public void setTimeExpression(String timeExpression) {
        this.timeExpression = timeExpression;
    }

    public Integer getLoopFlag() {
        return loopFlag;
    }

    public void setLoopFlag(Integer loopFlag) {
        this.loopFlag = loopFlag;
    }

    public String getMsgContent() {
        return msgContent;
    }

    public void setMsgContent(String msgContent) {
        this.msgContent = msgContent;
    }

    public Integer getLaterTime() {
        return laterTime;
    }

    public void setLaterTime(Integer laterTime) {
        this.laterTime = laterTime;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}