package cn.yoofans.manager.center.api.enums.message;

import java.util.Objects;

/**
 * 消息类型
 * Created by qiuyp
 */
public enum MsgTypeEnum {

    CUSTOMER_SERVICE(1, "客服消息");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    MsgTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static MsgTypeEnum getByCode(Integer code) {
        for (MsgTypeEnum value : MsgTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

    /**
     * 获取描述
     *
     * @param code
     * @return
     */
    public static String getDesc(Integer code) {
        if (null == code) return null;
        for (MsgTypeEnum value : MsgTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value.getDesc();
            }
        }
        return null;
    }

}
