package cn.yoofans.manager.center.api.enums.message;

import java.util.Objects;

/**
 * 通知类型
 * Created by qiuyp
 */
public enum NoticeTypeEnum {

    TRIGGER_CUSTOMER(1, "触发用户"),
    ATTENTION_CUSTOMER(2, "关注用户"),
    ASSIGN_CUSTOMER(3, "指定用户");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    NoticeTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static NoticeTypeEnum getByCode(Integer code) {
        for (NoticeTypeEnum value : NoticeTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

    /**
     * 获取描述
     *
     * @param code
     * @return
     */
    public static String getDesc(Integer code) {
        if (null == code) return null;
        for (NoticeTypeEnum value : NoticeTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value.getDesc();
            }
        }
        return null;
    }

}
