package cn.yoofans.manager.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.manager.center.api.dto.MsgReportDto;
import cn.yoofans.manager.center.api.dto.message.MessageConfigDTO;
import cn.yoofans.manager.center.api.param.message.MessagePageParams;
import org.springframework.data.domain.PageImpl;

import java.util.List;

/**
 * create by qiuyp
 */
@AdvancedFeignClient
public interface RemoteMessageConfigService {

    /**
     * 保存消息
     *
     * @param message
     * @return
     */
    Boolean saveMessage(MessageConfigDTO message);

    /**
     * 删除消息
     *
     * @param id
     * @return
     */
    Boolean deleteMessage(Long id);

    /**
     * 修改消息
     *
     * @param message
     * @return
     */
    Boolean updateMessage(MessageConfigDTO message);

    /**
     * 依据Id查询消息
     *
     * @param id
     * @return
     */
    MessageConfigDTO findOneById(Long id);

    /**
     * 分页查询消息列表
     *
     * @param param
     * @return
     */
    PageImpl<MessageConfigDTO> findPageList(MessagePageParams param);

    /**
     * 查询消息发送统计信息
     *
     * @param msgId
     * @return
     */
    List<MsgReportDto> findMsgStatistic(Long msgId);

}
