/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteLoadPageService
 * Author:   amu
 * Date:     2018/3/21 下午2:27
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.manager.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.manager.center.api.dto.LoadPageInfoDto;
import cn.yoofans.manager.center.api.dto.LoadPageMobileInfoDto;
import cn.yoofans.manager.center.api.dto.PutContentDto;

import java.util.List;

/**
 * 〈一句话功能简述〉<br>
 * 〈〉
 *
 * @author amu
 * @create 2018/3/21
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteLoadPageService {
    /**
     * 获取mobile端落地页皮肤
     * @param loadPageId
     * @return
     */
    String getLoadPageSkinInfo(Long loadPageId);

    /**
     * 获取mobile端落地页投放内容
     * @param loadPageId
     * @return
     */
    LoadPageMobileInfoDto getLoadPagePutContentInfo(Long loadPageId);

    /**
     * 添加
     * @param loadPageInfoDto
     * @return
     */
    boolean saveLoadPageInfo(LoadPageInfoDto loadPageInfoDto);


    /**
     * 修改
     * @param loadPageInfoDto
     * @return
     */
    boolean updateLoadPage(LoadPageInfoDto loadPageInfoDto);


    /**
     * 按照内容id查询落地页
     * @param putContentId
     * @return
     */
    List<LoadPageInfoDto> getLoadPagesByPutContentId(Long putContentId);

    /**
     * 分页查询的总数
     * @param subscriptionIds
     * @param status
     * @param loadPageUrl
     * @return
     */
    Long findByPageCount(List<Long> subscriptionIds, Integer status, String loadPageUrl);

    /**
     * 分页查询的数据
     * @param subscriptionIds
     * @param status
     * @param loadPageUrl
     * @return
     */
    List<LoadPageInfoDto> findByPage(List<Long> subscriptionIds, Integer status, String loadPageUrl, Integer pageNum ,Integer pageSize);

    /**
     * 按照落地页地址查询
     * @param loadPageUrl
     * @return
     */

    List<LoadPageInfoDto> findByLoadPageUrl(String loadPageUrl);

    /**
     * 批量查询
     * @param ids
     * @return
     */
    List<LoadPageInfoDto> findByIds(List<Long> ids);


}
