/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: WxMpTemplateMessage
 * Author:   amu
 * Date:     2018/5/14 下午3:01
 * Description: 微信公众号模板消息
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.wechat.api.dto.template;

import java.io.Serializable;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br> 
 * 〈微信公众号模板消息〉
 *
 * @author amu
 * @create 2018/5/14
 * @since 1.0.0
 */
public class WxMpTemplateMessage implements Serializable{
    private static final long serialVersionUID = -5253892233531606153L;
    private String touser;
    private String template_id;
    private String url;
    private WxMpTemplateMessage.MiniProgram miniprogram;
    private Map<String,WxMpTemplateData> data;


    public String getTouser() {
        return touser;
    }

    public void setTouser(String touser) {
        this.touser = touser;
    }

    public String getTemplate_id() {
        return template_id;
    }

    public void setTemplate_id(String template_id) {
        this.template_id = template_id;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public MiniProgram getMiniprogram() {
        return miniprogram;
    }

    public void setMiniprogram(MiniProgram miniprogram) {
        this.miniprogram = miniprogram;
    }

    public Map<String, WxMpTemplateData> getData() {
        return data;
    }

    public void setData(Map<String, WxMpTemplateData> data) {
        this.data = data;
    }

    public static class MiniProgram implements Serializable{
        private static final long serialVersionUID = -9090195167577750162L;
        private String appid;
        private String pagepath;

        public String getAppid() {
            return appid;
        }

        public void setAppid(String appid) {
            this.appid = appid;
        }

        public String getPagepath() {
            return pagepath;
        }

        public void setPagepath(String pagepath) {
            this.pagepath = pagepath;
        }

        public MiniProgram() {
        }

        public MiniProgram(String appid, String pagepath) {
            this.appid = appid;
            this.pagepath = pagepath;
        }

        @Override
        public String toString() {
            return "MiniProgram{" + "appid='" + appid + '\'' + ", pagepath='" + pagepath + '\'' + '}';
        }
    }

    @Override
    public String toString() {
        return "WxMpTemplateMessage{" + "touser='" + touser + '\'' + ", template_id='" + template_id + '\'' + ", url='"
            + url + '\'' + ", miniprogram=" + miniprogram + ", data=" + data + '}';
    }
}
