package cn.yoofans.wechat.api.enums;

import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;

/**
 * 模版消息推送状态
 * Created by sunyan on 2018/2/1.
 */
public enum PushStatusEnum {
    UNPUSH(0, "待推送"),
    PUSHED(1, "已推送");

    private final int key;

    // 枚举描述
    private final String desc;

    PushStatusEnum(final int key, final String desc ) {
        this.key = key;
        this.desc = desc;
    }

    public static PushStatusEnum getByKey(int key) {
        Collection<PushStatusEnum> result = Collections2.filter(Arrays.asList(values()), (gs) -> {
            return gs.getKey()==key;
        });
        return result.isEmpty() ? null : result.iterator().next();
    }

    public int getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }
}
