package cn.yoofans.wechat.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.wechat.api.dto.miniapp.DomainDto;
import cn.yoofans.wechat.api.dto.miniapp.SessionDto;
import cn.yoofans.wechat.api.dto.miniapp.WxMiniappTemplateDto;

import java.util.List;

/**
 * Created by sunyan on 2018/1/25.
 */
@AdvancedFeignClient
public interface RemoteWechatMiniAppService {
    /**
     * 小程序登陆code换sessionkey
     * @param appid 小程序appid
     * @param code 登录时获取的 code
     * @return
     */
    SessionDto jscode2session(String appid, String code) throws BizException;

    /**
     * 获得所有小程序模版
     * @return
     */
    List<WxMiniappTemplateDto> selectAllTemplate();

    /**
     * 查询服务器地址
     * @param appId
     */
    DomainDto getDomain(String appId) throws BizException;

    /**
     * 修改服务器地址
     * @param appId
     */
    void setDomain(String appId);

    /**
     * 更新模版库
     */
    void refreshTemplate();

    /**
     * 为授权的小程序帐号上传小程序代码
     * @param templateId
     * @param appId
     * @return
     */
    boolean commit(Long templateId,String appId);

    /**
     * 提交审核
     * @param appId
     * @return
     */
    boolean submitAudit(String appId);

    /**
     * 手动刷新审核状态
     * @param appId
     */
    void updateAuditstatus(String appId);

    /**
     * 发布审核通过的版本
     * @param appId
     */
    void release(String appId) throws BizException;

    /**
     * 撤回审核
     * @param appId
     */
    void undocodeaudit(String appId) throws BizException;
}
