package cn.yoofans.wechat.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.wechat.api.dto.Oauth2codeDto;
import cn.yoofans.wechat.api.dto.UserinfoBeanDto;

/**
 * Created by sunyan on 2018/5/8.
 */
@AdvancedFeignClient
public interface RemoteWxH5KnowledgeService {

    /**
     * 获取服务号授权登陆连接
     * @param redirect
     * @param appId
     * @return
     */
    String getOAuthUrl(String redirect,String appId );

    String getOAuthUrlForManagerPlat(String redirect, String appId);

    public UserinfoBeanDto getWxUserInfoForManagerPlat(String authorizerAppid, String code);

        /**
         * 获取服务号静默授权登陆连接
         * @param redirect
         * @param appId
         * @return
         */
    String getBaseOAuthUrl(String redirect,String appId );


    /**
     * 获取服务号回调用户信息
     * @param authorizerAppid
     * @param code
     * @return
     */
    UserinfoBeanDto getWxUserInfo(String authorizerAppid, String code);

    /**
     * 获取网页授权基础信息
     * @param authorizerAppid
     * @param code
     * @return
     */
    Oauth2codeDto getOauth2codeInfo(String authorizerAppid, String code);
}
