package cn.yoofans.wechat.api.enums;

import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by sunyan .
 * 2018/5/22 .
 */
public enum EventEnum {

    UNSUBSCRIBE("unsubscribe", 2, "取消订阅"),
    SUBSCRIBE("subscribe", 1, "订阅");

    private String key;

    private int value;

    private String desc;

    public static EventEnum getByKey(String key) {
        Collection<EventEnum> result = Collections2.filter(Arrays.asList(values()), (gs) -> {
            return gs.getKey().equals(key);
        });
        return result.isEmpty() ? null : result.iterator().next();
    }

    EventEnum(String key, int value, String desc) {
        this.key = key;
        this.value = value;
        this.desc = desc;
    }

    public String getKey() {
        return key;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
