package cn.yoofans.wechat.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.wechat.api.dto.miniapp.*;
import cn.yoofans.wechat.api.param.AddEventTemplateParam;
import cn.yoofans.wechat.api.param.AddMsgTemplateParam;

import java.util.List;

/**
 * Created by sunyan on 2018/2/2.
 */
@AdvancedFeignClient
public interface RemoteMpMsgTemplateService {
    /**
     * 查询小程序下所有消息模版(不带关键词列表，需要单个查询)
     * @param appId
     * @return
     */
    List<MpMsgTemplateDto> selectNotDelByAppId(String appId);
    /**
     * 获取模板库某个模板标题下关键词库
     * @param appId
     * @param atId
     * @return
     * @throws BizException
     */
    TemplateMsgDto templateLibraryGet(String appId, String atId) throws BizException;

    /**
     * 添加模版消息模版
     * @param addMsgTemplateParam
     * @return
     */
    Boolean addMsgTemplate(AddMsgTemplateParam addMsgTemplateParam);

    /**
     * 查询小程序模版详情
     * @param id
     * @return
     */
    MpMsgTemplateDto selectMsgTemplate(Long id);

    /**
     * 删除模版
     * @param appId
     * @param id
     * @return
     */
    Boolean delMsgTemplate(String appId,Long id);

    /**
     * 保存计划任务
     * @param push
     * @param keyList
     * @return
     */
    Boolean saveTemplatePush(MpMsgTemplatePushDto push, List<MpPushKeyDto> keyList);

    /**
     * 指定日期和事件类型下的推送计划列表
     * @param odpsId
     * @return
     */
    List<MpMsgTemplatePushListDto> templatePushList(Long odpsId);

    /**
     * 查询推送任务
     * @param id
     * @return
     */
    MpMsgTemplatePushDto selectTemplatePush(Long id);
    /**
     * 删除推送任务
     * @param appId
     * @param id
     * @return
     */
    Boolean delTemplatePush(String appId,Long id);

    /**
     * 新增小程序推送触发
     * @param addEventTemplateParam
     * @return
     */
    Boolean addEventTemplate(AddEventTemplateParam addEventTemplateParam);
}
