package cn.yoofans.wechat.api.enums;

import com.google.common.collect.Collections2;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by sunchangji on 2018/1/30.
 */
public enum WxEventFormTypeEnum {
    MAILA_ROB(1, "抢购");

    private int type;
    private String desc;

    WxEventFormTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getByType(final int type) {
        Collection<WxEventFormTypeEnum> result = Collections2.filter(Arrays.asList(WxEventFormTypeEnum.values()), gs -> gs.getType() == type);
        return result.isEmpty() ? StringUtils.EMPTY : result.iterator().next().getDesc();
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
