package com.duiba.tuia.abtest.api.dto;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 广告算法定制版
 * ABTest 输出结果
 */
public class ABAdvertResponseBatchDto implements Serializable {

    /**
     * 是否走实验
     */
    private boolean success;

    /**
     * 实验异常信息
     */
    private String msg;

    /**
     * 批量实验结果
     */
    private List<ABResultDto> result;

    public ABAdvertResponseBatchDto() {

    }

    public ABAdvertResponseBatchDto(boolean success) {
        this.success = success;
    }

    public ABAdvertResponseBatchDto(boolean success, String msg) {
        this.success = success;
        this.msg = msg;
    }

    public ABAdvertResponseBatchDto(boolean success, List<ABResultDto> list) {
        this.success = success;
        this.result = list;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public List<ABResultDto> getResult() {
        return result;
    }

    public void setResult(List<ABResultDto> result) {
        this.result = result;
    }
}
