package com.duiba.tuia.abtest.api.dto;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 广告算法定制版
 * ABTest 输出结果
 */
public class ABAdvertResponseDto implements Serializable {

    /**
     * 是否走实验
     */
    private boolean success;

    /**
     * 实验异常信息
     */
    private String msg;

    /**
     * 层对应的实验结果
     */
    private Map<String,ABResultDto> result;

    public ABAdvertResponseDto() {

    }

    public ABAdvertResponseDto(boolean success) {
        this.success = success;
    }

    public ABAdvertResponseDto(boolean success, String msg) {
        this.success = success;
        this.msg = msg;
    }

    public ABAdvertResponseDto(boolean success, Map<String,ABResultDto> list) {
        this.success = success;
        this.result = list;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Map<String, ABResultDto> getResult() {
        return result;
    }

    public void setResult(Map<String, ABResultDto> result) {
        this.result = result;
    }
}
