package com.duiba.tuia.abtest.api.dto;

import java.io.Serializable;

public class ABResultDto implements Serializable {

    /**
     * 是否走实验组
     */
    private boolean success;
    /**
     * 实验组测试异常信息
     */
    private String msg;
    /**
     * 测试层
     */
    private String layerCode;
    /**
     * 测试组ID
     */
    private String groupId;
    /**
     * 测试组Name
     */
    private String groupName;
    /**
     * 实验类型：人工还是算法
     */
    private String testType;
    /**
     * 实验结果
     */
    private String testValue;

    /**
     * 实验ID,为了支持同时返回多层实验结果
     */
    private Long planId;

    /**
     * extra参数,用于区分同一个广告计划里不同受众的返回实验
     **/
    private String extra;

    /**
     * 空跑状态: 0-不空跑 1-空跑中 2-空跑结束
     **/
    private Integer dryRunStatus;

    /**
     * 域标记:0-平行流量,1-域流量
     **/
    private Integer domainStatus;

    public ABResultDto() {

    }

    public ABResultDto(boolean success) {
        this.success = success;
    }

    public ABResultDto(boolean success, String layerCode, String msg) {
        this.success = success;
        this.layerCode = layerCode;
        this.msg = msg;
    }

    public boolean isSuccess() {
        return success;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getLayerCode() {
        return layerCode;
    }

    public void setLayerCode(String layerCode) {
        this.layerCode = layerCode;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getTestType() {
        return testType;
    }

    public void setTestType(String testType) {
        this.testType = testType;
    }

    public String getTestValue() {
        return testValue;
    }

    public void setTestValue(String testValue) {
        this.testValue = testValue;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public Integer getDryRunStatus() {
        return dryRunStatus;
    }

    public void setDryRunStatus(Integer dryRunStatus) {
        this.dryRunStatus = dryRunStatus;
    }

    public Integer getDomainStatus() {
        return domainStatus;
    }

    public void setDomainStatus(Integer domainStatus) {
        this.domainStatus = domainStatus;
    }
}
