package com.duiba.tuia.abtest.api.dto;

import com.duiba.tuia.abtest.api.advertreq.TestConditionReq;
import com.duiba.tuia.abtest.api.advertreq.TestPlanGroupReq;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 广告计划维度实验计划对象
 */
@Data
public class AdvertTestPlanDTO implements Serializable {

    /** 实验计划id **/
    private Long id;

    /** 实验名称 **/
    private String testPlanName;

    /** 测试状态:0未开始,1进行中,2已结束 **/
    private Integer testStatus;

    /** 开始时间 **/
    private Date startTime;

    /** 结束时间 **/
    private Date endTime;

    /** 实验描述 **/
    private String testPlanDesc;

    /** 对应的测试层,实验组(对应广告是落地页或者券) **/
    private Map<String, List<TestPlanGroupReq>> testPlanGroups;

    /** 受众条件List对象(对应广告是 配置ID) **/
    private List<TestConditionReq> conditionValues;

    /** 实验场景id 1-素材 2-活动 3-广告 4-广告算法") **/
    private Integer testTypeId;
}
