package com.duiba.tuia.abtest.api.dto;

import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.util.Set;

@Data
@ApiModel
public class TestSlotPlanDTO implements Serializable {

    private static final long serialVersionUID = -334499116286647122L;

    /**
     * 测试计划ID
     */
    private Long planId;

    /**
     * 流量比例百分比%
     */
    private Integer percent;

    /**
     * 流量比例的区间 1～100:  1,2,5,6
     */
    private String percentDistrict;

    /**
     * 流量比例的区间Set用于快速匹配
     */
    private Set<Integer> percentDistrictSet;

    /**
     * 实验计划公共信息
     */
    private TestPlanDTO testPlan;



}
