package com.duiba.tuia.abtest.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.duiba.tuia.abtest.api.advertreq.AdvertTestPlanReq;
import com.duiba.tuia.abtest.api.advertreq.StatusModifyReq;
import com.duiba.tuia.abtest.api.dto.AdvertTestPlanDTO;
import com.duiba.tuia.abtest.api.dto.AdvertTestPlanStatusDTO;

import java.util.List;
import java.util.Set;

/**
 * ABTest 配置暴露相关接口
 */
@AdvancedFeignClient
public interface RemoteABTestConfigService {

    /**
     * @Description 保存实验计划 (新建/编辑)
     * @Param [param]
     * @return java.lang.Boolean
     **/
    Boolean saveTestPlan(AdvertTestPlanReq param) throws BizException;


    /**
     * @Description 删除
     * @Param [param]
     * @return java.lang.Booleanlist
     **/
    Boolean delTestPlan(StatusModifyReq req) throws BizException;


    /**
     * @Description 停止
     * @Param [param]
     * @return java.lang.Boolean
     **/
    Boolean stopTestPlan(StatusModifyReq req) throws BizException;


    /**
     * 列表查询
     * */
    List<AdvertTestPlanDTO> getList(Long advertId) throws BizException;


    /**
     * 广告计划-实验计划及状态列表查询(用于广告线List的数据填充)
     * */
    List<AdvertTestPlanStatusDTO> getPlanListWithStatus(List<Long> advertIds) throws BizException;

    /**
     * 广告计划-根据广告和层ID
     * @param advertIds
     * @param layerCode
     * @return testStatus = 0/1/2 同一advertId 返回ID最大的一条
     */
    List<AdvertTestPlanStatusDTO> getPlanListByAdverLayer(List<Long> advertIds, String layerCode);

    /**
     * @Description
     * @Date 4:10 下午 2021/2/23
     * @Param []
     * @return java.util.Set<java.lang.Long>
     **/
    Set<Long> runningAdvertIds() throws BizException;
}
