/*
 * Decompiled with CFR 0.152.
 */
package com.duiba.tuia.abtest.sdk;

import com.duiba.tuia.abtest.api.dto.ABAdvertResponseBatchDto;
import com.duiba.tuia.abtest.api.dto.ABAdvertResponseDto;
import com.duiba.tuia.abtest.api.dto.ABRequestDto;
import com.duiba.tuia.abtest.api.dto.ABResponseDto;
import com.duiba.tuia.abtest.api.dto.ABResultDto;
import com.duiba.tuia.abtest.api.dto.TestPlanGroupDTO;
import com.duiba.tuia.abtest.api.dto.TestSlotDTO;
import com.duiba.tuia.abtest.api.dto.TestSlotPlanDTO;
import com.duiba.tuia.abtest.api.dto.UserWhiteListDO;
import com.duiba.tuia.abtest.api.remoteservice.RemoteABTestService;
import com.duiba.tuia.abtest.cache.CacheManager;
import com.duiba.tuia.abtest.filter.ABTestFilter;
import com.duiba.tuia.abtest.log.AsyncLog;
import com.duiba.tuia.abtest.sdk.ABTestInterface;
import hash.HashSplitFlow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ABTestSDK
implements ABTestInterface {
    protected Logger logger = LoggerFactory.getLogger(ABTestSDK.class);
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private ABTestFilter abTestFilter;
    @Autowired
    private AsyncLog asyncLog;
    @Autowired
    private RemoteABTestService remoteABTestService;

    @Override
    public ABResponseDto run(ABRequestDto request) {
        TestSlotDTO slotPlan = null;
        try {
            slotPlan = this.cacheManager.testPlanCacheGet(request.getSlotId());
        }
        catch (ExecutionException e) {
            slotPlan = this.NullObject(request.getSlotId());
            this.logger.warn("\u5f02\u5e38\u8fd4\u56de\u7a7a\u5bf9\u8c61:[{}]", (Throwable)e);
        }
        List<TestSlotPlanDTO> testPlans = this.abTestFilter.filter(request.getExtra(), request.getLayerCode(), slotPlan);
        if (testPlans.isEmpty()) {
            this.asyncLog.setInnerLog(request);
            return new ABResponseDto(false, "\u6ca1\u6709\u5b9e\u9a8c");
        }
        UserWhiteListDO userWhiteListDO = this.abTestFilter.filterWithWhiteList(testPlans, request.getDeviceId());
        if (Objects.nonNull(userWhiteListDO)) {
            ABResultDto result;
            TestSlotPlanDTO testPlan = new TestSlotPlanDTO();
            for (TestSlotPlanDTO testSlotPlanDTO : testPlans) {
                if (!Objects.equals(testSlotPlanDTO.getPlanId(), userWhiteListDO.getPlanId())) continue;
                testPlan = testSlotPlanDTO;
            }
            TestPlanGroupDTO current = null;
            List testPlanGroupDTOS = (List)testPlan.getTestPlan().getTestPlanGroups().get(request.getLayerCode());
            for (TestPlanGroupDTO testPlanGroupDTO : testPlanGroupDTOS) {
                if (!Objects.equals(testPlanGroupDTO.getGroupId(), userWhiteListDO.getGroupId())) continue;
                current = testPlanGroupDTO;
            }
            if (current != null) {
                result = new ABResultDto(true);
                result.setLayerCode(current.getTestLayerCode());
                result.setGroupId(current.getGroupId());
                result.setGroupName(current.getGroupName());
                result.setTestType(current.getTestType());
                result.setTestValue(current.getTestValue());
                result.setPlanId(testPlan.getPlanId());
            } else {
                result = new ABResultDto(false, request.getLayerCode(), "\u6ca1\u6709\u5206\u6d41\u5230\u6d4b\u8bd5\u7ec4");
            }
            ArrayList<ABResultDto> results = new ArrayList<ABResultDto>();
            results.add(result);
            this.asyncLog.setInnerLog(testPlan, results, request);
            return new ABResponseDto(true, testPlan.getPlanId().longValue(), results);
        }
        TestSlotPlanDTO plan = HashSplitFlow.domainHash(testPlans, request, false, 0);
        if (plan == null) {
            this.asyncLog.setInnerLog(request);
            return new ABResponseDto(false, "\u6ca1\u6709\u5206\u6d41\u5230\u5b9e\u9a8c");
        }
        List<ABResultDto> layerResult = HashSplitFlow.layerHash(plan, request, false, false);
        this.asyncLog.setInnerLog(plan, layerResult, request);
        return new ABResponseDto(true, plan.getPlanId().longValue(), layerResult);
    }

    @Override
    public ABAdvertResponseDto advertRun(ABRequestDto request) {
        List<String> layerCodes = Arrays.asList(request.getLayerCode().split(","));
        HashMap total = new HashMap();
        layerCodes.forEach(layerCode -> {
            TestSlotDTO slotPlan;
            Boolean isDomain = false;
            Integer domainPercent = 0;
            request.setLayerCode(layerCode);
            List<Object> testPlans = new ArrayList();
            if (Objects.nonNull(request.getAdvertId())) {
                slotPlan = null;
                try {
                    slotPlan = this.cacheManager.advertTestPlanCacheGet(request.getAdvertId());
                }
                catch (ExecutionException e) {
                    slotPlan = this.NullObject(request.getSlotId());
                    this.logger.warn("\u5f02\u5e38\u8fd4\u56de\u7a7a\u5bf9\u8c61:[{}]", (Throwable)e);
                }
                testPlans = this.abTestFilter.filter(request.getExtra(), request.getLayerCode(), slotPlan);
                isDomain = this.isDomainHash(testPlans, request);
                domainPercent = this.getDomainPercent(testPlans);
                if (!isDomain.booleanValue()) {
                    testPlans = this.filterNotDomainPlans(testPlans);
                }
            } else {
                slotPlan = null;
                try {
                    slotPlan = this.cacheManager.advertAlgoPlanCacheGet(request.getLayerCode());
                }
                catch (ExecutionException e) {
                    slotPlan = this.NullObject(request.getLayerCode());
                    this.logger.warn("\u5f02\u5e38\u8fd4\u56de\u7a7a\u5bf9\u8c61:[{}]", (Throwable)e);
                }
                testPlans = this.abTestFilter.filter(request.getExtra(), request.getLayerCode(), slotPlan);
            }
            if (testPlans.isEmpty()) {
                this.asyncLog.setInnerLog(request);
                return;
            }
            TestSlotPlanDTO plan = HashSplitFlow.domainHash(testPlans, request, isDomain, domainPercent);
            if (plan == null) {
                this.asyncLog.setInnerLog(request);
                return;
            }
            List<ABResultDto> layerResult = HashSplitFlow.layerHash(plan, request, true, isDomain);
            if (!layerResult.get(0).isSuccess()) {
                this.asyncLog.setInnerLog(plan, layerResult, request);
                return;
            }
            this.asyncLog.setInnerLog(plan, layerResult, request);
            total.put(layerResult.get(0).getLayerCode(), layerResult.get(0));
        });
        if (total.isEmpty()) {
            return new ABAdvertResponseDto(false, "\u6ca1\u6709\u8bd5\u9a8c");
        }
        return new ABAdvertResponseDto(true, total);
    }

    @Override
    public ABAdvertResponseDto advertRunWithRemote(ABRequestDto request) {
        return this.remoteABTestService.advertRun(request);
    }

    @Override
    public ABAdvertResponseBatchDto advertRunBatch(List<ABRequestDto> requests) {
        ArrayList total = new ArrayList();
        requests.forEach(request -> {
            TestSlotPlanDTO plan;
            TestSlotDTO slotPlan = null;
            try {
                slotPlan = this.cacheManager.advertTestPlanCacheGet(request.getAdvertId());
            }
            catch (ExecutionException e) {
                slotPlan = this.NullObject(request.getAdvertId());
                this.logger.warn("\u5f02\u5e38\u8fd4\u56de\u7a7a\u5bf9\u8c61:[{}]", (Throwable)e);
            }
            List<TestSlotPlanDTO> testPlans = this.abTestFilter.filter(request.getExtra(), request.getLayerCode(), slotPlan);
            if (testPlans.isEmpty()) {
                this.asyncLog.setInnerLog((ABRequestDto)request);
                return;
            }
            Boolean isDomain = this.isDomainHash(testPlans, (ABRequestDto)request);
            Integer domainPercent = this.getDomainPercent(testPlans);
            if (!isDomain.booleanValue()) {
                testPlans = this.filterNotDomainPlans(testPlans);
            }
            if ((plan = HashSplitFlow.domainHash(testPlans, request, isDomain, domainPercent)) == null) {
                this.asyncLog.setInnerLog((ABRequestDto)request);
                return;
            }
            List<ABResultDto> layerResult = HashSplitFlow.layerHash(plan, request, true, isDomain);
            if (!layerResult.get(0).isSuccess()) {
                this.asyncLog.setInnerLog(plan, layerResult, (ABRequestDto)request);
                return;
            }
            this.asyncLog.setInnerLog(plan, layerResult, (ABRequestDto)request);
            layerResult.get(0).setExtra(request.getExtra());
            total.add(layerResult.get(0));
        });
        if (CollectionUtils.isEmpty(total)) {
            return new ABAdvertResponseBatchDto(false, "\u6ca1\u6709\u8bd5\u9a8c");
        }
        return new ABAdvertResponseBatchDto(true, total);
    }

    private TestSlotDTO NullObject(String layerCode) {
        TestSlotDTO dto = new TestSlotDTO();
        dto.setSlotId(Long.valueOf(-1L));
        dto.setTestLayerCode(layerCode);
        dto.setId(Long.valueOf(-1L));
        dto.setTestPlans(new ArrayList());
        return dto;
    }

    private TestSlotDTO NullObject(Long slotId) {
        TestSlotDTO dto = new TestSlotDTO();
        dto.setSlotId(slotId);
        dto.setId(Long.valueOf(-1L));
        dto.setTestPlans(new ArrayList());
        return dto;
    }

    private Boolean isDomainHash(List<TestSlotPlanDTO> testPlans, ABRequestDto request) {
        int domainHash = 0;
        domainHash = HashSplitFlow.hash(request.getDeviceId()) % 100;
        TestSlotPlanDTO current = null;
        for (TestSlotPlanDTO slotPlan : testPlans) {
            if (!slotPlan.getPercentDistrictSet().contains(domainHash) || slotPlan.getTestPlan().getDomainType() != 1) continue;
            current = slotPlan;
            break;
        }
        return current != null;
    }

    private List<TestSlotPlanDTO> filterNotDomainPlans(List<TestSlotPlanDTO> testPlans) {
        testPlans = testPlans.stream().filter(o -> o.getTestPlan().getDomainType() == 0).collect(Collectors.toList());
        return testPlans;
    }

    private Integer getDomainPercent(List<TestSlotPlanDTO> testPlans) {
        if (CollectionUtils.isEmpty(testPlans)) {
            return 0;
        }
        Integer domainPercent = 0;
        for (TestSlotPlanDTO testPlan : testPlans) {
            if (testPlan.getTestPlan().getDomainType() != 1) continue;
            domainPercent = domainPercent + testPlan.getPercent();
        }
        return domainPercent;
    }
}

