/*
 * Decompiled with CFR 0.152.
 */
package hash;

import com.duiba.tuia.abtest.api.dto.ABRequestDto;
import com.duiba.tuia.abtest.api.dto.ABResultDto;
import com.duiba.tuia.abtest.api.dto.TestPlanGroupDTO;
import com.duiba.tuia.abtest.api.dto.TestSlotPlanDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;

public class HashSplitFlow {
    private static final Random random = new Random();

    public static TestSlotPlanDTO domainHash(List<TestSlotPlanDTO> testPlans, ABRequestDto request, Boolean isDomain, Integer domainPercent) {
        int domainHash = 0;
        domainHash = isDomain != false ? HashSplitFlow.hash(request.getDeviceId()) % 100 : (Objects.equals(testPlans.get(0).getTestPlan().getSplitType(), 1) ? random.nextInt(100 - domainPercent) : HashSplitFlow.hash(request.getDeviceId() + request.getSlotId() + request.getLayerCode()) % (100 - domainPercent));
        TestSlotPlanDTO current = null;
        for (TestSlotPlanDTO slotPlan : testPlans) {
            if (!slotPlan.getPercentDistrictSet().contains(domainHash)) continue;
            current = slotPlan;
            break;
        }
        return current;
    }

    public static List<ABResultDto> layerHash(TestSlotPlanDTO planDTO, ABRequestDto request, boolean isAdvert, Boolean isDomain) {
        ABResultDto result;
        int layerHash = 0;
        layerHash = isDomain != false ? HashSplitFlow.hash(request.getDeviceId() + planDTO.getPlanId()) % 100 : (Objects.equals(planDTO.getTestPlan().getSplitType(), 1) ? random.nextInt(100) : (isAdvert ? HashSplitFlow.hash(request.getDeviceId() + request.getLayerCode() + planDTO.getPlanId()) % 100 : HashSplitFlow.hash(request.getDeviceId() + request.getSlotId() + request.getLayerCode() + planDTO.getPlanId()) % 100));
        List groups = (List)planDTO.getTestPlan().getTestPlanGroups().get(request.getLayerCode());
        TestPlanGroupDTO current = null;
        for (TestPlanGroupDTO group : groups) {
            if (!group.getPercentDistrictSet().contains(layerHash)) continue;
            current = group;
            break;
        }
        if (current != null) {
            result = new ABResultDto(true);
            result.setLayerCode(current.getTestLayerCode());
            result.setGroupId(current.getGroupId());
            result.setGroupName(current.getGroupName());
            result.setTestType(current.getTestType());
            result.setTestValue(current.getTestValue());
            result.setPlanId(planDTO.getPlanId());
            result.setDomainStatus(Integer.valueOf(isDomain != false ? 1 : 0));
        } else {
            result = new ABResultDto(false, request.getLayerCode(), "\u6ca1\u6709\u5206\u6d41\u5230\u6d4b\u8bd5\u7ec4 hash:" + layerHash);
        }
        ArrayList<ABResultDto> results = new ArrayList<ABResultDto>();
        results.add(result);
        return results;
    }

    public static int hash(String str) {
        String HashStr = DigestUtils.md5Hex((String)str);
        int hash = HashStr.length();
        for (int i = 0; i < HashStr.length(); ++i) {
            hash = hash << 5 ^ hash >> 27 ^ HashStr.charAt(i);
        }
        int hashCode = hash & Integer.MAX_VALUE;
        return hashCode < 0 ? -hashCode : hashCode;
    }
}

