/*
 * Decompiled with CFR 0.152.
 */
package com.duiba.tuia.abtest.sdk.cache;

import com.duiba.tuia.abtest.api.dto.ABCacheRequestDto;
import com.duiba.tuia.abtest.api.dto.TestSlotDTO;
import com.duiba.tuia.abtest.api.remoteservice.RemoteABTestService;
import com.duiba.tuia.abtest.sdk.config.ABTestConfig;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CacheManager {
    @Autowired
    private ABTestConfig abTestConfig;
    @Autowired
    private RemoteABTestService remoteABTestService;
    @Autowired
    private ExecutorService executorService;
    private LoadingCache<Long, TestSlotDTO> testPlanCache;
    private LoadingCache<Long, TestSlotDTO> advertTestPlanCache;
    private LoadingCache<String, TestSlotDTO> advertAlgoPlanCache;
    private final CacheLoader cacheLoader = new CacheLoader<Long, TestSlotDTO>(){

        public TestSlotDTO load(Long slotId) throws Exception {
            return CacheManager.this.remoteABTestService.getSlotCache(slotId);
        }

        public ListenableFuture<TestSlotDTO> reload(Long key, TestSlotDTO oldValue) throws Exception {
            ListenableFutureTask task = ListenableFutureTask.create(() -> {
                try {
                    return this.load(key);
                }
                catch (Exception e) {
                    return oldValue;
                }
            });
            CacheManager.this.executorService.submit((Runnable)task);
            return task;
        }
    };
    private final CacheLoader advertCacheLoader = new CacheLoader<Long, TestSlotDTO>(){

        public TestSlotDTO load(Long advertId) throws Exception {
            ABCacheRequestDto cacheRequestDto = new ABCacheRequestDto();
            cacheRequestDto.setAdvertId(advertId);
            return CacheManager.this.remoteABTestService.getAdvertCache(cacheRequestDto);
        }

        public ListenableFuture<TestSlotDTO> reload(Long key, TestSlotDTO oldValue) throws Exception {
            ListenableFutureTask task = ListenableFutureTask.create(() -> {
                try {
                    return this.load(key);
                }
                catch (Exception e) {
                    return oldValue;
                }
            });
            CacheManager.this.executorService.submit((Runnable)task);
            return task;
        }
    };
    private final CacheLoader advertAlgoCacheLoader = new CacheLoader<String, TestSlotDTO>(){

        public TestSlotDTO load(String layerCode) throws Exception {
            return CacheManager.this.remoteABTestService.getAdvertAlgoCache(layerCode);
        }

        public ListenableFuture<TestSlotDTO> reload(String key, TestSlotDTO oldValue) throws Exception {
            ListenableFutureTask task = ListenableFutureTask.create(() -> {
                try {
                    return this.load(key);
                }
                catch (Exception e) {
                    return oldValue;
                }
            });
            CacheManager.this.executorService.submit((Runnable)task);
            return task;
        }
    };

    @PostConstruct
    public void init() {
        this.testPlanCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(5000L).refreshAfterWrite((long)this.abTestConfig.getCACHE_REFRESH_MILLS().intValue(), TimeUnit.SECONDS).expireAfterWrite((long)this.abTestConfig.getCACHE_EXPIRE_MILLS().intValue(), TimeUnit.SECONDS).build(this.cacheLoader);
        this.advertTestPlanCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(5000L).refreshAfterWrite((long)this.abTestConfig.getCACHE_REFRESH_MILLS().intValue(), TimeUnit.SECONDS).expireAfterWrite((long)this.abTestConfig.getCACHE_EXPIRE_MILLS().intValue(), TimeUnit.SECONDS).build(this.advertCacheLoader);
        this.advertAlgoPlanCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(5000L).refreshAfterWrite((long)this.abTestConfig.getCACHE_REFRESH_MILLS().intValue(), TimeUnit.SECONDS).expireAfterWrite((long)this.abTestConfig.getCACHE_EXPIRE_MILLS().intValue(), TimeUnit.SECONDS).build(this.advertAlgoCacheLoader);
    }

    public TestSlotDTO testPlanCacheGet(Long slotId) throws ExecutionException {
        return (TestSlotDTO)this.testPlanCache.get((Object)slotId);
    }

    public TestSlotDTO advertTestPlanCacheGet(Long advertId) throws ExecutionException {
        return (TestSlotDTO)this.advertTestPlanCache.get((Object)advertId);
    }

    public TestSlotDTO advertAlgoPlanCacheGet(String layerCode) throws ExecutionException {
        return (TestSlotDTO)this.advertAlgoPlanCache.get((Object)layerCode);
    }
}

