/*
 * Decompiled with CFR 0.152.
 */
package com.duiba.tuia.abtest.sdk.filter;

import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.abtest.api.dto.TestConditionDTO;
import com.duiba.tuia.abtest.api.dto.TestPlanDTO;
import com.duiba.tuia.abtest.api.dto.TestSlotDTO;
import com.duiba.tuia.abtest.api.dto.TestSlotPlanDTO;
import com.duiba.tuia.abtest.api.dto.UserWhiteListDO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ABTestFilter {
    protected Logger logger = LoggerFactory.getLogger(ABTestFilter.class);

    public List<TestSlotPlanDTO> filter(String extra, String layerCode, TestSlotDTO dto) {
        List slotPlans = dto.getTestPlans();
        ArrayList<TestSlotPlanDTO> plans = new ArrayList<TestSlotPlanDTO>();
        Date now = new Date();
        for (TestSlotPlanDTO slotPlan : slotPlans) {
            TestPlanDTO planDTO = slotPlan.getTestPlan();
            if (Objects.isNull(planDTO)) {
                this.logger.warn("\u5b9e\u9a8c\u8ba1\u5212\u4e3a\u7a7a!,layerCode:[{}],extra:[{}]", (Object)layerCode, (Object)extra);
            }
            if (now.before(planDTO.getStartTime()) || now.after(planDTO.getEndTime()) || planDTO.getTestPlanGroups().get(layerCode) == null) continue;
            List conditionValues = planDTO.getConditionValues();
            if (CollectionUtils.isEmpty((Collection)conditionValues)) {
                plans.add(slotPlan);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)extra)) continue;
            Map<String, String> conditionValueMap = JSONObject.parseObject((String)extra).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
            boolean flag = false;
            for (TestConditionDTO conditionValue : conditionValues) {
                String s = conditionValueMap.get(conditionValue.getConditionField());
                if (StringUtils.isBlank((CharSequence)s)) {
                    flag = false;
                    break;
                }
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                List conditionValueList = conditionValue.getConditionValueList();
                if (conditionValueList.contains(s)) {
                    flag = true;
                    continue;
                }
                flag = false;
                break;
            }
            if (!flag) continue;
            plans.add(slotPlan);
        }
        return plans;
    }

    public UserWhiteListDO filterWithWhiteList(List<TestSlotPlanDTO> testPlans, String deviceId) {
        for (TestSlotPlanDTO testPlan : testPlans) {
            if (Objects.isNull(testPlan.getTestPlan()) || CollectionUtils.isEmpty((Collection)testPlan.getTestPlan().getWhiteLists())) continue;
            List whiteLists = testPlan.getTestPlan().getWhiteLists();
            for (UserWhiteListDO whiteList : whiteLists) {
                if (!Objects.equals(whiteList.getDeviceId(), deviceId)) continue;
                return whiteList;
            }
        }
        return null;
    }
}

