/*
 * Decompiled with CFR 0.152.
 */
package com.duiba.tuia.abtest.sdk.log;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.abtest.api.dto.ABRequestDto;
import com.duiba.tuia.abtest.api.dto.ABResultDto;
import com.duiba.tuia.abtest.api.dto.PlanLogDTO;
import com.duiba.tuia.abtest.api.dto.TestSlotPlanDTO;
import com.duiba.tuia.abtest.sdk.config.ABTestConfig;
import com.duiba.tuia.abtest.sdk.log.InnerLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AsyncLog {
    @Autowired
    private ABTestConfig abTestConfig;
    LinkedBlockingDeque<JSONObject> queue = new LinkedBlockingDeque();
    protected Logger logger = LoggerFactory.getLogger(AsyncLog.class);

    @PostConstruct
    public void init() {
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
        executorService.scheduleAtFixedRate(() -> {
            int size = this.queue.size();
            if (size == 0) {
                return;
            }
            ArrayList<JSONObject> requestTests = new ArrayList<JSONObject>();
            for (int i = 0; i < size; ++i) {
                JSONObject poll = this.queue.poll();
                requestTests.add(poll);
            }
            this.logger.info("\u65e5\u5fd7\u5408\u5e76\u4e86" + requestTests.size() + "\u6761\uff01");
            for (JSONObject json : requestTests) {
                this.log("1", json);
            }
        }, 0L, this.abTestConfig.getLOG_TIME().intValue(), TimeUnit.MILLISECONDS);
    }

    public void setInnerLog(ABRequestDto request) {
        JSONObject json = new JSONObject();
        json.put("device_id", (Object)request.getDeviceId());
        json.put("slot_id", (Object)request.getSlotId());
        json.put("advert_id", (Object)request.getAdvertId());
        if (StringUtils.isNotBlank((CharSequence)request.getRid())) {
            json.put("rid", (Object)request.getRid());
        }
        ArrayList<PlanLogDTO> list = new ArrayList<PlanLogDTO>();
        PlanLogDTO planLog = new PlanLogDTO();
        planLog.setLayer_code(request.getLayerCode());
        planLog.setIs_hit(Integer.valueOf(0));
        list.add(planLog);
        json.put("plan", (Object)JSON.toJSONString(list));
        this.queue.add(json);
    }

    public void setInnerLog(TestSlotPlanDTO plan, List<ABResultDto> layerResult, ABRequestDto request) {
        JSONObject json = new JSONObject();
        json.put("device_id", (Object)request.getDeviceId());
        json.put("slot_id", (Object)request.getSlotId());
        json.put("advert_id", (Object)request.getAdvertId());
        json.put("plan_id", (Object)plan.getPlanId());
        ArrayList list = new ArrayList();
        layerResult.forEach(layer -> {
            PlanLogDTO planLog = new PlanLogDTO();
            planLog.setLayer_code(layer.getLayerCode());
            if (Objects.equals(layer.isSuccess(), true)) {
                planLog.setIs_hit(Integer.valueOf(1));
                planLog.setGroup_id(layer.getGroupId());
            } else {
                planLog.setIs_hit(Integer.valueOf(0));
            }
            list.add(planLog);
        });
        json.put("plan", (Object)JSON.toJSONString(list));
        this.queue.add(json);
    }

    public void log(String type, Object data) {
        if (data == null) {
            return;
        }
        InnerLog innerlog = new InnerLog();
        innerlog.setGroup("2");
        innerlog.setType(type);
        innerlog.setJson(JSONObject.toJSONString((Object)data));
        innerlog.setTime(new DateTime().toString("yyyy-MM-dd HH:mm:ss"));
        String log = JSONObject.toJSONString((Object)innerlog);
        InnerLog.info(log);
    }
}

