/*
 * Decompiled with CFR 0.152.
 */
package com.duiba.tuia.abtest.sdk.cache;

import com.duiba.tuia.abtest.api.dto.ABCacheRequestDto;
import com.duiba.tuia.abtest.api.dto.TestSlotDTO;
import com.duiba.tuia.abtest.api.remoteservice.RemoteABTestService;
import com.duiba.tuia.abtest.sdk.config.ABTestConfig;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AbTestCacheManager {
    private ABTestConfig abTestConfig;
    private RemoteABTestService remoteABTestService;
    private AsyncLoadingCache<Long, TestSlotDTO> testPlanCache = Caffeine.newBuilder().initialCapacity(100).maximumSize(5000L).refreshAfterWrite(15L, TimeUnit.SECONDS).buildAsync(key -> this.remoteABTestService.getSlotCache(key));
    private AsyncLoadingCache<Long, TestSlotDTO> advertTestPlanCache = Caffeine.newBuilder().initialCapacity(100).maximumSize(5000L).refreshAfterWrite(15L, TimeUnit.SECONDS).buildAsync(key -> {
        ABCacheRequestDto cacheRequestDto = new ABCacheRequestDto();
        cacheRequestDto.setAdvertId(key);
        return this.remoteABTestService.getAdvertCache(cacheRequestDto);
    });
    private AsyncLoadingCache<String, TestSlotDTO> advertAlgoPlanCache = Caffeine.newBuilder().initialCapacity(100).maximumSize(5000L).refreshAfterWrite(15L, TimeUnit.SECONDS).buildAsync(key -> this.remoteABTestService.getAdvertAlgoCache(key));

    public AbTestCacheManager(@Autowired ABTestConfig abTestConfig, @Autowired RemoteABTestService remoteABTestService) {
        this.abTestConfig = abTestConfig;
        this.remoteABTestService = remoteABTestService;
    }

    public TestSlotDTO testPlanCacheGet(Long slotId) {
        return this.testPlanCache.get((Object)slotId).getNow(null);
    }

    public TestSlotDTO advertTestPlanCacheGet(Long advertId) {
        return this.advertTestPlanCache.get((Object)advertId).getNow(null);
    }

    public TestSlotDTO advertAlgoPlanCacheGet(String layerCode) {
        return this.advertAlgoPlanCache.get((Object)layerCode).getNow(null);
    }
}

