package com.qiho.center.api.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author huangruodan
 * @version 创建时间：2021/4/16 下午3:10
 */
@Data
public class CheatApiConfigDto implements Serializable {

    private static final long serialVersionUID = -5059212134613359462L;

    private Long id;

    /**
     * 配置类型 {@link com.qiho.center.api.enums.order.CheatApiConfigTypeEnum}
     */
    private Integer configType;

    /**
     * 配置名称
     */
    private String configName;

    /**
     * 创建人
     */
    private String configCreator;

    /**
     * 修改人
     */
    private String configUpdator;

    /**
     * 固定参数
     */
    private List<String> checkParams;

    /**
     * 接口地址
     */
    private String apiAddress;

    /**
     * 接口域名
     */
    private String serverDomain;

    /**
     * 其他参数
     */
    private Map<String, String> otherParams;

    /**
     * 备注
     */
    private String configComment;

}
