package com.qiho.center.api.dto.trading.withdrawal;

import com.qiho.center.api.enums.trading.withdrawal.WithdrawalApplyStatus;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Wangpf
 * @description
 * @date 2020/9/2 2:56 下午
 */
@Data
public class ShopTradingWithdrawalApplyRecordDto implements Serializable {
    /**
     * 主键Id
     */
    private Long id;

    /**
     * 店铺Id
     */
    private Long shopId;

    /**
     * 申请人Id
     */
    private Long applyId;

    /**
     * 申请时间
     */
    private String applyTime;

    /**
     * 申请人姓名
     */
    private String applyName;

    /**
     * 申请金额
     */
    private Integer applyAmt;

    /**
     * 申请状态 {@link WithdrawalApplyStatus#getCode()}
     */
    private Integer applyStatus;

    /**
     * 审核人Id
     */
    private Long auditId;

    /**
     * 审核人姓名
     */
    private String auditName;

    /**
     * 完成时间
     */
    private String finishTime;

    /**
     * 创建时间
     */
    private String gmtCreate;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * 公司名称
     */
    private String companyName;
}
