package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeHBEnum implements AreaCodeEnumerable {
    CODE_130000("130000", "河北省"),
    CODE_130100("130100", "河北省石家庄市"),
    CODE_130101("130101", "河北省石家庄市市辖区"),
    CODE_130102("130102", "河北省石家庄市长安区"),
    CODE_130103("130103", "河北省石家庄市桥东区"),
    CODE_130104("130104", "河北省石家庄市桥西区"),
    CODE_130105("130105", "河北省石家庄市新华区"),
    CODE_130106("130106", "河北省石家庄市郊区"),
    CODE_130107("130107", "河北省石家庄市井陉矿区"),
    CODE_130121("130121", "河北省石家庄市井陉县"),
    CODE_130123("130123", "河北省石家庄市正定县"),
    CODE_130124("130124", "河北省石家庄市栾城县"),
    CODE_130125("130125", "河北省石家庄市行唐县"),
    CODE_130126("130126", "河北省石家庄市灵寿县"),
    CODE_130127("130127", "河北省石家庄市高邑县"),
    CODE_130128("130128", "河北省石家庄市深泽县"),
    CODE_130129("130129", "河北省石家庄市赞皇县"),
    CODE_130130("130130", "河北省石家庄市无极县"),
    CODE_130131("130131", "河北省石家庄市平山县"),
    CODE_130132("130132", "河北省石家庄市元氏县"),
    CODE_130133("130133", "河北省石家庄市赵县"),
    CODE_130181("130181", "河北省石家庄市辛集市"),
    CODE_130182("130182", "河北省石家庄市藁城市"),
    CODE_130183("130183", "河北省石家庄市晋州市"),
    CODE_130184("130184", "河北省石家庄市新乐市"),
    CODE_130185("130185", "河北省石家庄市鹿泉市"),
    CODE_130200("130200", "河北省唐山市"),
    CODE_130201("130201", "河北省唐山市市辖区"),
    CODE_130202("130202", "河北省唐山市路南区"),
    CODE_130203("130203", "河北省唐山市路北区"),
    CODE_130204("130204", "河北省唐山市古冶区"),
    CODE_130205("130205", "河北省唐山市开平区"),
    CODE_130206("130206", "河北省唐山市新区"),
    CODE_130221("130221", "河北省唐山市丰润县"),
    CODE_130223("130223", "河北省唐山市滦县"),
    CODE_130224("130224", "河北省唐山市滦南县"),
    CODE_130225("130225", "河北省唐山市乐亭县"),
    CODE_130227("130227", "河北省唐山市迁西县"),
    CODE_130229("130229", "河北省唐山市玉田县"),
    CODE_130230("130230", "河北省唐山市唐海县"),
    CODE_130281("130281", "河北省唐山市遵化市"),
    CODE_130282("130282", "河北省唐山市丰南市"),
    CODE_130283("130283", "河北省唐山市迁安市"),
    CODE_130300("130300", "河北省秦皇岛市秦皇岛市"),
    CODE_130301("130301", "河北省秦皇岛市市辖区"),
    CODE_130302("130302", "河北省秦皇岛市海港区"),
    CODE_130303("130303", "河北省秦皇岛市山海关区"),
    CODE_130304("130304", "河北省秦皇岛市北戴河区"),
    CODE_130321("130321", "河北省秦皇岛市青龙满族自治县"),
    CODE_130322("130322", "河北省秦皇岛市昌黎县"),
    CODE_130323("130323", "河北省秦皇岛市抚宁县"),
    CODE_130324("130324", "河北省秦皇岛市卢龙县"),
    CODE_130400("130400", "河北省邯郸市邯郸市"),
    CODE_130401("130401", "河北省邯郸市市辖区"),
    CODE_130402("130402", "河北省邯郸市邯山区"),
    CODE_130403("130403", "河北省邯郸市丛台区"),
    CODE_130404("130404", "河北省邯郸市复兴区"),
    CODE_130406("130406", "河北省邯郸市峰峰矿区"),
    CODE_130421("130421", "河北省邯郸市邯郸县"),
    CODE_130423("130423", "河北省邯郸市临漳县"),
    CODE_130424("130424", "河北省邯郸市成安县"),
    CODE_130425("130425", "河北省邯郸市大名县"),
    CODE_130426("130426", "河北省邯郸市涉县"),
    CODE_130427("130427", "河北省邯郸市磁县"),
    CODE_130428("130428", "河北省邯郸市肥乡县"),
    CODE_130429("130429", "河北省邯郸市永年县"),
    CODE_130430("130430", "河北省邯郸市邱县"),
    CODE_130431("130431", "河北省邯郸市鸡泽县"),
    CODE_130432("130432", "河北省邯郸市广平县"),
    CODE_130433("130433", "河北省邯郸市馆陶县"),
    CODE_130434("130434", "河北省邯郸市魏县"),
    CODE_130435("130435", "河北省邯郸市曲周县"),
    CODE_130481("130481", "河北省邯郸市武安市"),
    CODE_130500("130500", "河北省邢台市"),
    CODE_130501("130501", "河北省邢台市市辖区"),
    CODE_130502("130502", "河北省邢台市桥东区"),
    CODE_130503("130503", "河北省邢台市桥西区"),
    CODE_130521("130521", "河北省邢台市邢台县"),
    CODE_130522("130522", "河北省邢台市临城县"),
    CODE_130523("130523", "河北省邢台市内丘县"),
    CODE_130524("130524", "河北省邢台市柏乡县"),
    CODE_130525("130525", "河北省邢台市隆尧县"),
    CODE_130526("130526", "河北省邢台市任县"),
    CODE_130527("130527", "河北省邢台市南和县"),
    CODE_130528("130528", "河北省邢台市宁晋县"),
    CODE_130529("130529", "河北省邢台市巨鹿县"),
    CODE_130530("130530", "河北省邢台市新河县"),
    CODE_130531("130531", "河北省邢台市广宗县"),
    CODE_130532("130532", "河北省邢台市平乡县"),
    CODE_130533("130533", "河北省邢台市威县"),
    CODE_130534("130534", "河北省邢台市清河县"),
    CODE_130535("130535", "河北省邢台市临西县"),
    CODE_130581("130581", "河北省邢台市南宫市"),
    CODE_130582("130582", "河北省邢台市沙河市"),
    CODE_130600("130600", "河北省保定市"),
    CODE_130601("130601", "河北省保定市市辖区"),
    CODE_130602("130602", "河北省保定市新市区"),
    CODE_130603("130603", "河北省保定市北市区"),
    CODE_130604("130604", "河北省保定市南市区"),
    CODE_130621("130621", "河北省保定市满城县"),
    CODE_130622("130622", "河北省保定市清苑县"),
    CODE_130623("130623", "河北省保定市涞水县"),
    CODE_130624("130624", "河北省保定市阜平县"),
    CODE_130625("130625", "河北省保定市徐水县"),
    CODE_130626("130626", "河北省保定市定兴县"),
    CODE_130627("130627", "河北省保定市唐县"),
    CODE_130628("130628", "河北省保定市高阳县"),
    CODE_130629("130629", "河北省保定市容城县"),
    CODE_130630("130630", "河北省保定市涞源县"),
    CODE_130631("130631", "河北省保定市望都县"),
    CODE_130632("130632", "河北省保定市安新县"),
    CODE_130633("130633", "河北省保定市易县"),
    CODE_130634("130634", "河北省保定市曲阳县"),
    CODE_130635("130635", "河北省保定市蠡县"),
    CODE_130636("130636", "河北省保定市顺平县"),
    CODE_130637("130637", "河北省保定市博野县"),
    CODE_130638("130638", "河北省保定市雄县"),
    CODE_130681("130681", "河北省保定市涿州市"),
    CODE_130682("130682", "河北省保定市定州市"),
    CODE_130683("130683", "河北省保定市安国市"),
    CODE_130684("130684", "河北省保定市高碑店市"),
    CODE_130700("130700", "河北省张家口市"),
    CODE_130701("130701", "河北省张家口市市辖区"),
    CODE_130702("130702", "河北省张家口市桥东区"),
    CODE_130703("130703", "河北省张家口市桥西区"),
    CODE_130705("130705", "河北省张家口市宣化区"),
    CODE_130706("130706", "河北省张家口市下花园区"),
    CODE_130721("130721", "河北省张家口市宣化县"),
    CODE_130722("130722", "河北省张家口市张北县"),
    CODE_130723("130723", "河北省张家口市康保县"),
    CODE_130724("130724", "河北省张家口市沽源县"),
    CODE_130725("130725", "河北省张家口市尚义县"),
    CODE_130726("130726", "河北省张家口市蔚县"),
    CODE_130727("130727", "河北省张家口市阳原县"),
    CODE_130728("130728", "河北省张家口市怀安县"),
    CODE_130729("130729", "河北省张家口市万全县"),
    CODE_130730("130730", "河北省张家口市怀来县"),
    CODE_130731("130731", "河北省张家口市涿鹿县"),
    CODE_130732("130732", "河北省张家口市赤城县"),
    CODE_130733("130733", "河北省张家口市崇礼县"),
    CODE_130800("130800", "河北省承德市"),
    CODE_130801("130801", "河北省承德市市辖区"),
    CODE_130802("130802", "河北省承德市双桥区"),
    CODE_130803("130803", "河北省承德市双滦区"),
    CODE_130804("130804", "河北省承德市鹰手营子矿区"),
    CODE_130821("130821", "河北省承德市承德县"),
    CODE_130822("130822", "河北省承德市兴隆县"),
    CODE_130823("130823", "河北省承德市平泉县"),
    CODE_130824("130824", "河北省承德市滦平县"),
    CODE_130825("130825", "河北省承德市隆化县"),
    CODE_130826("130826", "河北省承德市丰宁满族自治县"),
    CODE_130827("130827", "河北省承德市宽城满族自治县"),
    CODE_130828("130828", "河北省承德市围场满族蒙古族自治县"),
    CODE_130900("130900", "河北省沧州市"),
    CODE_130901("130901", "河北省沧州市市辖区"),
    CODE_130902("130902", "河北省沧州市新华区"),
    CODE_130903("130903", "河北省沧州市运河区"),
    CODE_130921("130921", "河北省沧州市沧县"),
    CODE_130922("130922", "河北省沧州市青县"),
    CODE_130923("130923", "河北省沧州市东光县"),
    CODE_130924("130924", "河北省沧州市海兴县"),
    CODE_130925("130925", "河北省沧州市盐山县"),
    CODE_130926("130926", "河北省沧州市肃宁县"),
    CODE_130927("130927", "河北省沧州市南皮县"),
    CODE_130928("130928", "河北省沧州市吴桥县"),
    CODE_130929("130929", "河北省沧州市献县"),
    CODE_130930("130930", "河北省沧州市孟村回族自治县"),
    CODE_130981("130981", "河北省沧州市泊头市"),
    CODE_130982("130982", "河北省沧州市任丘市"),
    CODE_130983("130983", "河北省沧州市黄骅市"),
    CODE_130984("130984", "河北省沧州市河间市"),
    CODE_131000("131000", "河北省廊坊市"),
    CODE_131001("131001", "河北省廊坊市市辖区"),
    CODE_131002("131002", "河北省廊坊市安次区"),
    CODE_131022("131022", "河北省廊坊市固安县"),
    CODE_131023("131023", "河北省廊坊市永清县"),
    CODE_131024("131024", "河北省廊坊市香河县"),
    CODE_131025("131025", "河北省廊坊市大城县"),
    CODE_131026("131026", "河北省廊坊市文安县"),
    CODE_131028("131028", "河北省廊坊市大厂回族自治县"),
    CODE_131081("131081", "河北省廊坊市霸州市"),
    CODE_131082("131082", "河北省廊坊市三河市"),
    CODE_131100("131100", "河北省衡水市"),
    CODE_131101("131101", "河北省衡水市市辖区"),
    CODE_131102("131102", "河北省衡水市桃城区"),
    CODE_131121("131121", "河北省衡水市枣强县"),
    CODE_131122("131122", "河北省衡水市武邑县"),
    CODE_131123("131123", "河北省衡水市武强县"),
    CODE_131124("131124", "河北省衡水市饶阳县"),
    CODE_131125("131125", "河北省衡水市安平县"),
    CODE_131126("131126", "河北省衡水市故城县"),
    CODE_131127("131127", "河北省衡水市景县"),
    CODE_131128("131128", "河北省衡水市阜城县"),
    CODE_131181("131181", "河北省衡水市冀州市"),
    CODE_131182("131182", "河北省衡水市深州市"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeHBEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
