package com.qiho.center.api.remoteservice.wukong;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.params.WuKongApp;

/**
 * @author Wangpf
 * @description   网关相关接口，进行域名配置  risk-manager -> qiho-center -> 中台网关
 * @date 2021/9/14 3:33 下午
 */
@AdvancedFeignClient
public interface RemoteWuKongClient {

    /**
     * 网关添加项目域名映射
     * @param wuKongApp
     */
    void appendDomain(WuKongApp wuKongApp);

    /**
     * 获取某个项目所有的映射域名
     *
     * @param appName
     * @return
     */
    WuKongApp getApp(String appName);
}
