package com.qiho.center.api.util;

import com.google.common.collect.Sets;

import java.util.Set;

/**
 * 地域工具类
 *
 * @author zhangbaiqiang
 * @date 2020/10/9
 */
public class AddressUtil {

    /** 直辖市 */
    private static final Set<String> municipalities = Sets.newHashSet("北京", "上海", "天津", "重庆");

    private AddressUtil() {}

    /**
     * 是否是直辖市
     *
     * @param city 城市
     * @return 是否是直辖市
     */
    public static boolean isMunicipality(String city) {
        return municipalities.contains(city);
    }
}
