package com.qiho.center.api.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

/**
 * @author huangruodan
 * @version 创建时间：2021/4/19 下午4:13
 */
public class MockDataUtil {

    /**
     * 省、自治区、直辖市代码
     */
    private static String provinces[] = { "11", "12", "13", "14", "15", "21", "22", "23",
        "31", "32", "33", "34", "35", "36", "37", "41", "42", "43",
        "44", "45", "46", "50", "51", "52", "53", "54", "61", "62",
        "63", "64", "65", "71", "81", "82" };

    /**
     * 地级市、盟、自治州代码
     */
    private static String citys[] = { "01", "02", "03", "04", "05", "06", "07", "08",
        "09", "10", "21", "22", "23", "24", "25", "26", "27", "28" };

    /**
     * 县、县级市、区代码
     */
    private static String countys[] = { "01", "02", "03", "04", "05", "06", "07", "08",
        "09", "10", "21", "22", "23", "24", "25", "26", "27", "28",
        "29", "30", "31", "32", "33", "34", "35", "36", "37", "38" };

    /**
     * 随机生成身份证
     * @return
     */
    public static String getRandomIDCard() {
        StringBuffer identityNo = new StringBuffer();

        // 随机生成省、自治区、直辖市代码 1-2
        identityNo.append(provinces[new Random().nextInt(provinces.length - 1)]);

        // 随机生成地级市、盟、自治州代码 3-4
        identityNo.append(citys[new Random().nextInt(citys.length - 1)]);

        // 随机生成县、县级市、区代码 5-6
        identityNo.append(countys[new Random().nextInt(countys.length - 1)]);

        // 随机生成出生年月 7-14
        SimpleDateFormat dft = new SimpleDateFormat("yyyyMMdd");
        Date beginDate = new Date();
        Calendar date = Calendar.getInstance();
        date.setTime(beginDate);
        date.set(Calendar.DATE, date.get(Calendar.DATE) - new Random().nextInt(365 * 100));
        identityNo.append(dft.format(date.getTime()));

        // 随机生成顺序号 15-17
        identityNo.append(new Random().nextInt(999));

        // 生成校验码 18
        identityNo.append(getVerifyCode(identityNo));
        return identityNo.toString();
    }

    /**
     * 计算校验码
     * @param cardId
     * @return
     */
    private static char getVerifyCode(StringBuffer cardId) {
        char[] ValCodeArr = {'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int[] Wi = {7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        int tmp = 0;
        for (int i = 0; i < Wi.length; i++) {
            tmp += Integer.parseInt(String.valueOf(cardId.charAt(i))) * Wi[i];
        }
        return ValCodeArr[tmp % 11];
    }

    /**
     * 随机生成手机号码
     * @return
     */
    public static String getPhoneNum() {
        //给予真实的初始号段，号段是在百度上面查找的真实号段
        String[] start = {"133", "149", "153", "173", "177",
                "180", "181", "189", "199", "130", "131", "132",
                 "145", "155", "156", "166", "171", "175", "176", "185", "186", "166", "134", "135",
                 "136", "137", "138", "139", "147", "150", "151", "152", "157", "158", "159", "172",
                 "178", "182", "183", "184", "187", "188", "198", "170", "171"};

        //随机出真实号段   使用数组的length属性，获得数组长度，
        //通过Math.random（）*数组长度获得数组下标，从而随机出前三位的号段
        String phoneFirstNum = start[(int) (Math.random() * start.length)];
        //随机出剩下的8位数
        StringBuilder phoneLastNum = new StringBuilder();
        //定义尾号，尾号是8位
        final int LENPHONE = 8;
        //循环剩下的位数
        for (int i = 0; i < LENPHONE; i++) {
             //每次循环都从0~9挑选一个随机数
             phoneLastNum.append((int) (Math.random() * 10));
         }
        //最终将号段和尾数连接起来
        return phoneFirstNum + phoneLastNum;
    }



    //百家姓
    private static String surname = "赵钱孙李周吴郑王冯陈褚卫蒋沈韩杨朱秦尤许何吕施张孔曹严华金魏陶姜戚谢邹喻柏水窦章云苏潘葛奚范彭郎鲁韦昌马苗凤花方俞任袁柳酆鲍史唐费廉岑薛雷贺倪汤滕殷罗毕郝邬安常乐于时傅皮卞齐康伍余元卜顾孟平黄和穆萧尹姚邵湛汪祁毛禹狄米贝明臧计伏成戴谈宋茅庞熊纪舒屈项祝董梁杜阮蓝闵席季麻强贾路娄危江童颜郭梅盛林刁钟徐邱骆高夏蔡田樊胡凌霍虞万支柯咎管卢莫经房裘缪干解应宗宣丁贲邓郁单杭洪包诸左石崔吉钮龚程嵇邢滑裴陆荣翁荀羊於惠甄魏加封芮羿储靳汲邴糜松井段富巫乌焦巴弓牧隗山谷车侯宓蓬全郗班仰秋仲伊宫宁仇栾暴甘钭厉戎祖武符刘姜詹束龙叶幸司韶郜黎蓟薄印宿白怀蒲台从鄂索咸籍赖卓蔺屠蒙池乔阴郁胥能苍双闻莘党翟谭贡劳逄姬申扶堵冉宰郦雍却璩桑桂濮牛寿通边扈燕冀郏浦尚农温别庄晏柴瞿阎充慕连茹习宦艾鱼容向古易慎戈廖庚终暨居衡步都耿满弘匡国文寇广禄阙东殴殳沃利蔚越夔隆师巩厍聂晁勾敖融冷訾辛阚那简饶空曾毋沙乜养鞠须丰巢关蒯相查后江红游竺权逯盖益桓公万俟司马上官欧阳夏侯诸葛闻人东方赫连皇甫尉迟公羊澹台公冶宗政濮阳淳于仲孙太叔申屠公孙乐正轩辕令狐钟离闾丘长孙慕容鲜于宇文司徒司空亓官司寇仉督子车颛孙端木巫马公西漆雕乐正壤驷公良拓拔夹谷宰父谷粱晋楚阎法汝鄢涂钦段干百里东郭南门呼延归海羊舌微生岳帅缑亢况后有琴梁丘左丘东门西门商牟佘佴伯赏南宫墨哈谯笪年爱阳佟";

    //女生名
    private static String girlName = "秀娟英华慧巧美娜静淑惠珠翠雅芝玉萍红娥玲芬芳燕彩春菊兰凤洁梅琳素云莲真环雪荣爱妹霞香月莺媛艳瑞凡佳嘉琼勤珍贞莉桂娣叶璧璐娅琦晶妍茜秋珊莎锦黛青倩婷姣婉娴瑾颖露瑶怡婵雁蓓纨仪荷丹蓉眉君琴蕊薇菁梦岚苑婕馨瑗琰韵融园艺咏卿聪澜纯毓悦昭冰爽琬茗羽希宁欣飘育滢馥筠柔竹霭凝晓欢霄枫芸菲寒伊亚宜可姬舒影荔枝思丽";

    //男生名
    private static String boyName = "伟刚勇毅俊峰强军平保东文辉力明永健世广志义兴良海山仁波宁贵福生龙元全国胜学祥才发武新利清飞彬富顺信子杰涛昌成康星光天达安岩中茂进林有坚和彪博诚先敬震振壮会思群豪心邦承乐绍功松善厚庆磊民友裕河哲江超浩亮政谦亨奇固之轮翰朗伯宏言若鸣朋斌梁栋维启克伦翔旭鹏泽晨辰士以建家致树炎德行时泰盛雄琛钧冠策腾楠榕风航弘";

    /**
     * 生成中文名称
     *
     * @return
     */
    public static String getChineseName() {
        int index = getNum(0, surname.length() - 1);
        String first = surname.substring(index, index + 1);
        int sex = getNum(0, 1);
        String str = boyName;
        int length = boyName.length();
        if (sex == 0) {
            str = girlName;
            length = girlName.length();
        }
        index = getNum(0, length - 1);
        String second = str.substring(index, index + 1);
        int hasThird = getNum(0, 1);
        String third = "";
        if (hasThird == 1) {
            index = getNum(0, length - 1);
            third = str.substring(index, index + 1);
        }
        return first + second + third;
    }

    public static int getNum(int start, int end) {
        return (int) (Math.random() * (end - start + 1) + start);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 100; i++) {
            String chineseName = getChineseName();
            System.out.println(chineseName);
        }
    }
}
