package com.qiho.center.api.util;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/*
 * @author Wangpf
 * @description SHA1加密的工具类
 * @date 2021/4/20 10:17 上午
 */
public abstract class SHA1 {

    public static Logger LOGGER = LoggerFactory.getLogger(SHA1.class);

    public static String sha1(String str) {
        if(str == null){
            return StringUtils.EMPTY;
        }

        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(str.getBytes());
            byte[] messageDigest = digest.digest();

            StringBuilder hexString = new StringBuilder();
            // 字节数组转换为 十六进制 数
            for (byte b : messageDigest) {
                String shaHex = Integer.toHexString(b & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();

        } catch (NoSuchAlgorithmException e) {
            LOGGER.error("sha1 error str:{}", str, e);
        }
        return StringUtils.EMPTY;
    }
}
