package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName: ErpErrorCodeEnum <br/>
 * Function: 返回给ERP系统的错误码枚举. <br/>
 * date: 2017年6月6日 下午4:05:02 <br/>
 *
 * @author chencheng
 * @version
 */
public enum ErpErrorCodeReturnEnum {
    /** 接口请求成功 */
    SUCCESS("0", "SUCCESS"),

    /** 订单编号不存在 */
    ORDER_CODE_NON_ERROR("1", "订单编号不存在"),
    
    /** 更新物流信息失败 */
    UPDATE_ERROR("2", "更新物流信息失败"),
    
    /** 其他原因 */
    OTHER_ERROR("999", "其他原因");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private ErpErrorCodeReturnEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * @param code
     * @return DatabaseSchema
     */
    public static ErpErrorCodeReturnEnum getByCode(String code) {
        for (ErpErrorCodeReturnEnum enumVal : ErpErrorCodeReturnEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
