package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeGSEnum implements AreaCodeEnumerable {
    CODE_620000("620000", "甘肃省"),
    CODE_620100("620100", "甘肃省兰州市"),
    CODE_620101("620101", "甘肃省兰州市市辖区"),
    CODE_620102("620102", "甘肃省兰州市城关区"),
    CODE_620103("620103", "甘肃省兰州市七里河区"),
    CODE_620104("620104", "甘肃省兰州市西固区"),
    CODE_620105("620105", "甘肃省兰州市安宁区"),
    CODE_620111("620111", "甘肃省兰州市红古区"),
    CODE_620121("620121", "甘肃省兰州市永登县"),
    CODE_620122("620122", "甘肃省兰州市皋兰县"),
    CODE_620123("620123", "甘肃省兰州市榆中县"),
    CODE_620200("620200", "甘肃省嘉峪关市"),
    CODE_620201("620201", "甘肃省嘉峪关市市辖区"),
    CODE_620300("620300", "甘肃省嘉峪关市金昌市"),
    CODE_620301("620301", "甘肃省嘉峪关市市辖区"),
    CODE_620302("620302", "甘肃省嘉峪关市金川区"),
    CODE_620321("620321", "甘肃省嘉峪关市永昌县"),
    CODE_620400("620400", "甘肃省白银市"),
    CODE_620401("620401", "甘肃省白银市市辖区"),
    CODE_620402("620402", "甘肃省白银市白银区"),
    CODE_620403("620403", "甘肃省白银市平川区"),
    CODE_620421("620421", "甘肃省白银市靖远县"),
    CODE_620422("620422", "甘肃省白银市会宁县"),
    CODE_620423("620423", "甘肃省白银市景泰县"),
    CODE_620500("620500", "甘肃省天水市"),
    CODE_620501("620501", "甘肃省天水市市辖区"),
    CODE_620502("620502", "甘肃省天水市秦城区"),
    CODE_620503("620503", "甘肃省天水市北道区"),
    CODE_620521("620521", "甘肃省天水市清水县"),
    CODE_620522("620522", "甘肃省天水市秦安县"),
    CODE_620523("620523", "甘肃省天水市甘谷县"),
    CODE_620524("620524", "甘肃省天水市武山县"),
    CODE_620525("620525", "甘肃省天水市张家川回族自治县"),
    CODE_622100("622100", "甘肃省酒泉地区"),
    CODE_622101("622101", "甘肃省酒泉地区玉门市"),
    CODE_622102("622102", "甘肃省酒泉地区酒泉市"),
    CODE_622103("622103", "甘肃省酒泉地区敦煌市"),
    CODE_622123("622123", "甘肃省酒泉地区金塔县"),
    CODE_622124("622124", "甘肃省酒泉地区肃北蒙古族自治县"),
    CODE_622125("622125", "甘肃省酒泉地区阿克塞哈萨克族自治县"),
    CODE_622126("622126", "甘肃省酒泉地区安西县"),
    CODE_622200("622200", "甘肃省张掖地区"),
    CODE_622201("622201", "甘肃省张掖地区张掖市"),
    CODE_622222("622222", "甘肃省张掖地区肃南裕固族自治县"),
    CODE_622223("622223", "甘肃省张掖地区民乐县"),
    CODE_622224("622224", "甘肃省张掖地区临泽县"),
    CODE_622225("622225", "甘肃省张掖地区高台县"),
    CODE_622226("622226", "甘肃省张掖地区山丹县"),
    CODE_622300("622300", "甘肃省武威地区"),
    CODE_622301("622301", "甘肃省武威地区武威市"),
    CODE_622322("622322", "甘肃省武威地区民勤县"),
    CODE_622323("622323", "甘肃省武威地区古浪县"),
    CODE_622326("622326", "甘肃省武威地区天祝藏族自治县"),
    CODE_622400("622400", "甘肃省定西地区"),
    CODE_622421("622421", "甘肃省定西地区定西县"),
    CODE_622424("622424", "甘肃省定西地区通渭县"),
    CODE_622425("622425", "甘肃省定西地区陇西县"),
    CODE_622426("622426", "甘肃省定西地区渭源县"),
    CODE_622427("622427", "甘肃省定西地区临洮县"),
    CODE_622428("622428", "甘肃省定西地区漳县"),
    CODE_622429("622429", "甘肃省定西地区岷县"),
    CODE_622600("622600", "甘肃省陇南地区"),
    CODE_622621("622621", "甘肃省陇南地区武都县"),
    CODE_622623("622623", "甘肃省陇南地区宕昌县"),
    CODE_622624("622624", "甘肃省陇南地区成县"),
    CODE_622625("622625", "甘肃省陇南地区康县"),
    CODE_622626("622626", "甘肃省陇南地区文县"),
    CODE_622627("622627", "甘肃省陇南地区西和县"),
    CODE_622628("622628", "甘肃省陇南地区礼县"),
    CODE_622629("622629", "甘肃省陇南地区两当县"),
    CODE_622630("622630", "甘肃省陇南地区徽县"),
    CODE_622700("622700", "甘肃省平凉地区"),
    CODE_622701("622701", "甘肃省平凉地区平凉市"),
    CODE_622722("622722", "甘肃省平凉地区泾川县"),
    CODE_622723("622723", "甘肃省平凉地区灵台县"),
    CODE_622724("622724", "甘肃省平凉地区崇信县"),
    CODE_622725("622725", "甘肃省平凉地区华亭县"),
    CODE_622726("622726", "甘肃省平凉地区庄浪县"),
    CODE_622727("622727", "甘肃省平凉地区静宁县"),
    CODE_622800("622800", "甘肃省庆阳地区"),
    CODE_622801("622801", "甘肃省庆阳地区西峰市"),
    CODE_622821("622821", "甘肃省庆阳地区庆阳县"),
    CODE_622822("622822", "甘肃省庆阳地区环县"),
    CODE_622823("622823", "甘肃省庆阳地区华池县"),
    CODE_622824("622824", "甘肃省庆阳地区合水县"),
    CODE_622825("622825", "甘肃省庆阳地区正宁县"),
    CODE_622826("622826", "甘肃省庆阳地区宁县"),
    CODE_622827("622827", "甘肃省庆阳地区镇原县"),
    CODE_622900("622900", "甘肃省临夏回族自治州"),
    CODE_622901("622901", "甘肃省临夏回族自治州临夏市"),
    CODE_622921("622921", "甘肃省临夏回族自治州临夏县"),
    CODE_622922("622922", "甘肃省临夏回族自治州康乐县"),
    CODE_622923("622923", "甘肃省临夏回族自治州永靖县"),
    CODE_622924("622924", "甘肃省临夏回族自治州广河县"),
    CODE_622925("622925", "甘肃省临夏回族自治州和政县"),
    CODE_622926("622926", "甘肃省临夏回族自治州东乡族自治县"),
    CODE_622927("622927", "甘肃省临夏回族自治州积石山保安族东乡族撒拉族自治县"),
    CODE_623000("623000", "甘肃省甘南藏族自治州"),
    CODE_623001("623001", "甘肃省甘南藏族自治州合作市"),
    CODE_623021("623021", "甘肃省甘南藏族自治州临潭县"),
    CODE_623022("623022", "甘肃省甘南藏族自治州卓尼县"),
    CODE_623023("623023", "甘肃省甘南藏族自治州舟曲县"),
    CODE_623024("623024", "甘肃省甘南藏族自治州迭部县"),
    CODE_623025("623025", "甘肃省甘南藏族自治州玛曲县"),
    CODE_623026("623026", "甘肃省甘南藏族自治州碌曲县"),
    CODE_623027("623027", "甘肃省甘南藏族自治州夏河县"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeGSEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
