package com.qiho.center.api.params;

import cn.com.tuia.advert.constants.CommonConstant;
import com.qiho.center.api.enums.log.PostPrintTypeEnum;

import java.io.Serializable;

/**
 * @author Wangpf
 * @description   订单日志参数
 * @date 2020/5/12 3:26 下午
 */
public class OrderSubTypeParam implements Serializable {

    private static final long serialVersionUID = -8107646810573185489L;
    /**
     * 日志类型 {@link com.qiho.center.api.enums.log.OrderLogSubTypeEnum}
     */
    private int subType;

    /**
     * 订单Id
     */
    private String orderId;

    /**
     * 商品Id
     */
    private String itemId;

    /**
     * 物流单号
     */
    private String postId;

    /**
     * 是否是可用的单号 {@link CommonConstant}
     */
    private Integer isAvailablePost;

    /**
     * 物流单号打印类型 {@link PostPrintTypeEnum#getPostPrintType()}
     */
    private Integer postPrintType;

    /**
     * 物流单号来源
     */
    private Integer source;

    /**
     * 获取一个对象的实例参数
     *
     * @param subType
     * @param orderId
     * @param itemId
     * @param postId
     * @param isAvailablePost
     * @param postPrintType
     * @return
     */
    public static OrderSubTypeParam getParamInstance(int subType, String orderId, String itemId, String postId
            , int isAvailablePost, int postPrintType, Integer source) {
        OrderSubTypeParam orderSubTypeParam = new OrderSubTypeParam();
        orderSubTypeParam.setSubType(subType);
        orderSubTypeParam.setOrderId(orderId);
        orderSubTypeParam.setItemId(itemId);
        orderSubTypeParam.setPostId(postId);
        orderSubTypeParam.setIsAvailablePost(isAvailablePost);
        orderSubTypeParam.setPostPrintType(postPrintType);
        orderSubTypeParam.setSource(source);
        return orderSubTypeParam;
    }

    public int getSubType() {
        return subType;
    }

    public void setSubType(int subType) {
        this.subType = subType;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getItemId() {
        return itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getPostId() {
        return postId;
    }

    public void setPostId(String postId) {
        this.postId = postId;
    }

    public Integer getIsAvailablePost() {
        return isAvailablePost;
    }

    public void setIsAvailablePost(Integer isAvailablePost) {
        this.isAvailablePost = isAvailablePost;
    }

    public Integer getPostPrintType() {
        return postPrintType;
    }

    public void setPostPrintType(Integer postPrintType) {
        this.postPrintType = postPrintType;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }
}
