package com.qiho.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.BannerDto;

import java.util.List;

/**
 * Created by Administrator on 2017/8/29 0029.
 */
@AdvancedFeignClient
public interface RemoteBannerService {

    /**
     * 根据id获取banner
     * @param id
     * @return
     */
    DubboResult<BannerDto> getBannerById(Long id);

    /**
     * 获取所有相同类型Banner
     * @return
     */
    DubboResult<List<BannerDto>> getAllBanners(String bannerType);

    /**
     * 获取有效的Banner
     * @return
     */
    DubboResult<List<BannerDto>> getValidBanners(String bannerType);

    /**
     * 创建或更新一条Banner
     * @param dto
     * @return
     */
    DubboResult<Boolean> saveBanner(BannerDto dto);

    /**
     * 删除一条Banner
     * @param id
     * @return
     */
    DubboResult<Boolean> deleteBanner(Long id);

    /**
     * 根据payload值排序
     * @return
     */
    DubboResult<Integer> sortBanner(String idList);

    /**
     * 获取最大的payload值
     * @return
     */
    DubboResult<Integer> findMaxPayload();
}
