package com.qiho.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.WechatApiPayNotifyDTO;
import com.qiho.center.api.params.AsyncAcceptParams;
import com.qiho.center.api.params.WechatApiPayNotifyParam;

import java.util.Map;

/**
 * Created by danke on 2017/7/24.
 * 在线支付
 */
@AdvancedFeignClient
public interface RemotePayService {

    /**
     * 在线支付
     * @param orderId
     * @param payType
     * @return
     */
    DubboResult<String> submitPay(String orderId,String payType);

    /**
     * 异步通知支付结果
     */
    DubboResult<Boolean> notifyCheck(AsyncAcceptParams params);

    /**
     * api支付结果通知校验
     */
    WechatApiPayNotifyDTO apiNotifyCheck(WechatApiPayNotifyParam param);

    /**
     * 服务商api支付结果通知校验
     * @param param
     * @return
     */
    WechatApiPayNotifyDTO serverNotifyCheck(WechatApiPayNotifyParam param);
    /**
     * 验签接口
     */
    DubboResult<Boolean> checkSign(String param,String payType);


    /**
     * 在线支付
     * @param orderId
     * @param payType
     * @return
     */
    DubboResult<String> submitPayWithParams(String orderId,String payType,Map<String,String>params);

	/**
     * 获取code
     * @param code
     * @return
     */
    DubboResult<String> getOpenIdByCode(String code);

    /**
     * 退款结果通知
     */
    DubboResult<Boolean> refundNotify(AsyncAcceptParams params);

    /**
     * 微信支付参数解密
     *
     * @param params 需要解密的参数
     * @return 解密后的参数
     */
    Map<String, String> wechatDecrypt(Map<String, String> params);
}
