package com.qiho.center.api.remoteservice.order;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.order.CheatApiConfigDto;
import com.qiho.center.api.dto.order.CheatApiConfigListDto;
import com.qiho.center.api.dto.order.CheatApiDebugResultDto;
import com.qiho.center.api.dto.order.param.CheatApiConfigListParam;

/**
 * @author huangruodan
 * @version 创建时间：2021/4/20 上午10:24
 */
@AdvancedFeignClient
public interface RemoteCheatApiConfigService {


    /**
     * 防作弊配置api列表
     * @param param 查询参数
     * @return
     */
    PagenationDto<CheatApiConfigListDto> getListByParam(CheatApiConfigListParam param) throws BizException;

    /**
     * 保存域名配置
     * @param param
     * @return
     */
    Long saveConfig(CheatApiConfigDto param) throws BizException;

    /**
     * 配置详情
     * @param id
     * @return
     */
    CheatApiConfigDto getDetailById(Long id) throws BizException;

    /**
     * 删除配置
     * @param id
     * @return
     */
    boolean deleteConfig(Long id) throws BizException;

    /**
     * 调试接口配置
     * @param id
     * @return
     */
    CheatApiDebugResultDto debugConfig(Long id) throws BizException;
}
