package com.qiho.center.api.util;

import cn.com.duiba.wolf.utils.BlowfishUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 为了防止竞品公司通过密钥刷百奇自建站的落地页，通过在URL上生成密钥的方式来校验访问的正确性
 *
 * @author Wangpf
 * @date 2023/8/28 10:14
 */
public abstract class GenerateLandSecretKeyUtils {

    private static final Logger logger = LoggerFactory.getLogger(GenerateLandSecretKeyUtils.class);

    /**
     * 这两个字符串不能修改 否则会导致线上在投的落地页无法打开
     */
    private static final String SALT = "-";
    private static final String KEY = "abc123";

    /**
     * 根据落地页ID和PID生成密钥
     *
     * @param pid 落地页ID
     * @param itemId 皮肤ID
     * @return
     */
    public static String generateLandSecretKey(Long pid, Long itemId) {
        if (pid == null || pid == null) {
            throw new IllegalArgumentException("landId or pid can not be null");
        }

        //先将落地页ID和皮肤ID转成字符串
        String str = pid + SALT + itemId;
        return BlowfishUtils.encryptBlowfish(str, KEY);
    }

    public static Long[] decryptSecretKey(String secret) {
        if (StringUtils.isBlank(secret)) {
            throw new IllegalArgumentException("密钥不能为空");
        }

        Long[] result = new Long[2];
        try {
            String s = BlowfishUtils.decryptBlowfish(secret, KEY);
            if (s == null) {
                throw new IllegalArgumentException("解密失败");
            }

            String[] split = s.split(SALT);
            result[0] = Long.valueOf(split[0]);
            result[1] = Long.valueOf(split[1]);

        } catch (Exception ex) {
            logger.warn("解密落地页Id失败 secret:{}", secret, ex);
        }

        return result;
    }

    public static void main(String[] args) {
        String s = generateLandSecretKey(1231L, 123L);
        System.out.println(s);

        Long[] longs = decryptSecretKey(s);

        System.out.println(longs[0]);
        System.out.println(longs[1]);
    }
}
